/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.common.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.GunCommonUtil;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunAttackStrafingTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidRangedWalkToTarget;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidUseShieldTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;

public class TaskGunAttack
implements IRangedAttackTask {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"gun_attack");
    private static ItemStack ICON;

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        if (ICON == null) {
            ICON = ((Item)InitItems.TACZ_GUN_ICON.get()).getDefaultInstance();
        }
        return ICON;
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.attackSound(maid, (SoundEvent)InitSounds.MAID_RANGE_ATTACK.get(), 0.5f);
    }

    @Override
    public boolean enableLookAndRandomWalk(EntityMaid maid) {
        return false;
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.create(this::mainhandHoldGun, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.create(target -> !this.mainhandHoldGun(maid) || this.farAway((LivingEntity)target, maid));
        BehaviorControl<EntityMaid> gunWalkTargetTask = MaidRangedWalkToTarget.create(0.6f);
        GunAttackStrafingTask gunAttackStrafingTask = new GunAttackStrafingTask();
        GunShootTargetTask gunShootTargetTask = new GunShootTargetTask();
        MaidUseShieldTask maidUseShieldTask = new MaidUseShieldTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, gunWalkTargetTask), Pair.of((Object)5, (Object)((Object)gunAttackStrafingTask)), Pair.of((Object)5, (Object)((Object)gunShootTargetTask)), Pair.of((Object)5, (Object)((Object)maidUseShieldTask))});
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createRideBrainTasks(EntityMaid maid) {
        BehaviorControl supplementedTask = StartAttacking.create(GunCommonUtil::canStartAttacking, IRangedAttackTask::findFirstValidAttackTarget);
        BehaviorControl findTargetTask = StopAttackingIfTargetInvalid.create(target -> !GunCommonUtil.canStartAttacking(maid) || this.farAway((LivingEntity)target, maid));
        GunShootTargetTask gunShootTargetTask = new GunShootTargetTask();
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)5, (Object)supplementedTask), Pair.of((Object)5, (Object)findTargetTask), Pair.of((Object)5, (Object)((Object)gunShootTargetTask))});
    }

    @Override
    public AABB searchDimension(EntityMaid maid) {
        if (GunCommonUtil.canStartAttacking(maid)) {
            float searchRange = this.searchRadius(maid);
            if (maid.hasRestriction()) {
                return new AABB(maid.getRestrictCenter()).inflate((double)searchRange);
            }
            return maid.getBoundingBox().inflate((double)searchRange);
        }
        return IRangedAttackTask.super.searchDimension(maid);
    }

    @Override
    public float searchRadius(EntityMaid maid) {
        return ((Integer)MaidConfig.MAID_GUN_LONG_DISTANCE.get()).intValue();
    }

    @Override
    public boolean canSee(EntityMaid maid, LivingEntity target) {
        return GunCommonUtil.canSee(maid, target).orElseGet(() -> IRangedAttackTask.super.canSee(maid, target));
    }

    @Override
    public List<Pair<String, Predicate<EntityMaid>>> getConditionDescription(EntityMaid maid) {
        return Collections.singletonList(Pair.of((Object)"has_gun", m -> this.isWeapon((EntityMaid)m, m.getMainHandItem())));
    }

    @Override
    public boolean isWeapon(EntityMaid maid, ItemStack stack) {
        return GunCommonUtil.isGun(stack);
    }

    private boolean mainhandHoldGun(EntityMaid maid) {
        ItemStack item = maid.getMainHandItem();
        return this.isWeapon(maid, item);
    }

    private boolean farAway(LivingEntity target, EntityMaid maid) {
        return maid.distanceTo((Entity)target) > this.searchRadius(maid);
    }

    @Override
    public void performRangedAttack(EntityMaid shooter, LivingEntity target, float distanceFactor) {
    }
}

