/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare;

import com.atsuishio.superbwarfare.data.gun.FireMode;
import com.atsuishio.superbwarfare.data.gun.GunData;
import com.atsuishio.superbwarfare.data.gun.GunProp;
import com.atsuishio.superbwarfare.entity.projectile.RgoGrenadeEntity;
import com.atsuishio.superbwarfare.entity.vehicle.base.VehicleEntity;
import com.atsuishio.superbwarfare.init.ModSounds;
import com.atsuishio.superbwarfare.item.HandGrenade;
import com.atsuishio.superbwarfare.item.RgoGrenade;
import com.atsuishio.superbwarfare.item.gun.GunItem;
import com.github.tartaricacid.touhoulittlemaid.api.task.IRangedAttackTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.common.ai.GunShootTargetTask;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.MaidAnimationPackage;
import java.util.Optional;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class SWarfareCompatInner {
    static boolean isGun(ItemStack stack) {
        return stack.getItem() instanceof GunItem;
    }

    static boolean isGrenade(ItemStack stack) {
        return stack.getItem() instanceof HandGrenade;
    }

    static boolean isVehicle(Entity entity) {
        return entity instanceof VehicleEntity;
    }

    static boolean shouldHideLivingRender(LivingEntity maid) {
        Entity entity = maid.getVehicle();
        if (entity instanceof VehicleEntity) {
            VehicleEntity vehicle = (VehicleEntity)entity;
            return vehicle.hidePassenger((Entity)maid);
        }
        return false;
    }

    static boolean canSee(EntityMaid maid, LivingEntity target) {
        ItemStack handItem = maid.getMainHandItem();
        if (!(handItem.getItem() instanceof GunItem)) {
            return BehaviorUtils.canSee((LivingEntity)maid, (LivingEntity)target);
        }
        GunData gunData = GunData.from((ItemStack)handItem);
        if (gunData == null) {
            return maid.canSee(target);
        }
        if (handItem.is(SWarfareCompat.SNIPER)) {
            return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
        }
        if (handItem.is(SWarfareCompat.PISTOL) || handItem.is(SWarfareCompat.SMG) || handItem.is(SWarfareCompat.SHOOTGUN)) {
            return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_NEAR_DISTANCE);
        }
        return IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_MEDIUM_DISTANCE);
    }

    static Optional<Boolean> canVehicleSee(EntityMaid maid, LivingEntity target) {
        Player player;
        Entity playerVehicle;
        Entity vehicle = maid.getVehicle();
        if (vehicle != null && SWarfareCompat.isVehicle(vehicle)) {
            boolean canSee = IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            return Optional.of(canSee);
        }
        LivingEntity owner = maid.getOwner();
        if (owner instanceof Player && (playerVehicle = (player = (Player)owner).getVehicle()) != null && playerVehicle.getPassengers().contains(maid) && SWarfareCompat.isVehicle(playerVehicle)) {
            boolean canSee = IRangedAttackTask.targetConditionsTest(maid, target, MaidConfig.MAID_GUN_LONG_DISTANCE);
            return Optional.of(canSee);
        }
        return Optional.empty();
    }

    static void tick(EntityMaid shooter, LivingEntity target, ItemStack gunItem) {
        if (!(gunItem.getItem() instanceof GunItem)) {
            return;
        }
        GunData gunData = GunData.from((ItemStack)gunItem);
        if (gunData == null) {
            return;
        }
        gunData.tick((Entity)shooter, true);
    }

    static void onStop(EntityMaid maid, GunShootTargetTask task) {
        ItemStack offhand = maid.getOffhandItem();
        if (offhand.getItem() instanceof RgoGrenade) {
            task.setAttackCooldown(50);
        }
    }

    static int performGunAttack(EntityMaid shooter, LivingEntity target, ItemStack gunItem) {
        if (!(gunItem.getItem() instanceof GunItem)) {
            return 100;
        }
        GunData gunData = GunData.from((ItemStack)gunItem);
        if (gunData == null) {
            return 100;
        }
        int result = SWarfareCompatInner.doGunReload(shooter, gunData);
        if (result > 0) {
            return result;
        }
        if (!gunData.canShoot((Entity)shooter)) {
            SWarfareCompatInner.useGrenade(shooter, target);
            return 50;
        }
        return SWarfareCompatInner.doGunShoot(shooter, target, gunItem, gunData);
    }

    private static void useGrenade(EntityMaid shooter, LivingEntity target) {
        ItemStack offhand = shooter.getOffhandItem();
        if (offhand.getItem() instanceof RgoGrenade && shooter.distanceTo((Entity)target) <= 16.0f) {
            SWarfareCompatInner.setViewRot(shooter, target);
            float power = 1.2f + shooter.getRandom().nextFloat() * 0.4f;
            RgoGrenadeEntity rgoGrenade = new RgoGrenadeEntity((LivingEntity)shooter, shooter.level, 40);
            rgoGrenade.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot(), 0.0f, power, 0.0f);
            shooter.level.addFreshEntity((Entity)rgoGrenade);
            shooter.level.playSound(null, shooter.blockPosition(), (SoundEvent)ModSounds.GRENADE_THROW.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
            offhand.shrink(1);
        }
    }

    private static int doGunReload(EntityMaid shooter, GunData gunData) {
        if (gunData.shouldStartReloading((Entity)shooter)) {
            gunData.startReload();
            MaidAnimationPackage msg = new MaidAnimationPackage(shooter.getId(), 3);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)shooter, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 5;
        }
        if (gunData.shouldStartBolt()) {
            gunData.startBolt();
            MaidAnimationPackage msg = new MaidAnimationPackage(shooter.getId(), 3);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)shooter, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
            return 5;
        }
        return -1;
    }

    private static int doGunShoot(EntityMaid shooter, LivingEntity target, ItemStack gunItem, GunData gunData) {
        boolean isSniper = gunItem.is(SWarfareCompat.SNIPER);
        if (isSniper && !shooter.isAiming()) {
            shooter.setAiming(true);
            return 20;
        }
        if (!isSniper) {
            float radius;
            float distance = shooter.distanceTo((Entity)target);
            if (distance <= (radius = shooter.getRestrictRadius()) && shooter.isAiming()) {
                shooter.setAiming(false);
                return 10;
            }
            if (distance > radius && !shooter.isAiming()) {
                shooter.setAiming(true);
                return 20;
            }
        }
        double rps = (double)((Integer)gunData.get(GunProp.RPM)).intValue() / 60.0;
        int cooldown = (int)Math.round(20.0 / rps);
        FireMode fireMode = (FireMode)gunData.fireMode.get();
        if (fireMode == FireMode.SEMI || fireMode == FireMode.BURST && gunData.burstAmount.get() == 0) {
            cooldown += 5 + shooter.getRandom().nextInt(5);
        }
        SWarfareCompatInner.setViewRot(shooter, target);
        gunData.shoot((Entity)shooter, 0.0, shooter.isAiming(), target.getUUID());
        MaidAnimationPackage msg = new MaidAnimationPackage(shooter.getId(), 4);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)shooter, (CustomPacketPayload)msg, (CustomPacketPayload[])new CustomPacketPayload[0]);
        return cooldown;
    }

    private static void setViewRot(EntityMaid shooter, LivingEntity target) {
        double x = target.getX() - shooter.getX();
        double y = target.getEyeY() - shooter.getEyeY();
        double z = target.getZ() - shooter.getZ();
        float yaw = (float)(-Math.toDegrees(Math.atan2(x, z)));
        float pitch = (float)(-Math.toDegrees(Math.atan2(y, Math.sqrt(x * x + z * z))));
        shooter.setXRot(pitch);
        shooter.setYRot(yaw);
    }
}

