/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.rei.transfer;

import com.github.tartaricacid.touhoulittlemaid.inventory.container.MaidMainContainer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class BackpackTransferHandler
implements SimpleTransferHandler {
    private final Class<? extends MaidMainContainer> containerClass;
    private final CategoryIdentifier<?> categoryIdentifier;
    private final int recipeSlotStart;
    private final int recipeSlotCount;
    private final int inventorySlotStart;
    private final int inventorySlotCount;

    public BackpackTransferHandler(Class<? extends MaidMainContainer> containerClass, CategoryIdentifier<?> categoryIdentifier, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.containerClass = containerClass;
        this.categoryIdentifier = categoryIdentifier;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
    }

    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        if (!this.containerClass.isInstance(context.getMenu()) || !this.categoryIdentifier.equals((Object)context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        return TransferHandler.ApplicabilityResult.createApplicable();
    }

    public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
        return IntStream.range(this.recipeSlotStart, this.recipeSlotStart + this.recipeSlotCount).mapToObj(id -> SlotAccessor.fromSlot((Slot)context.getMenu().getSlot(id))).toList();
    }

    public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
        AbstractContainerMenu menu = context.getMenu();
        return IntStream.range(this.inventorySlotStart, this.inventorySlotCount).mapToObj(index -> SlotAccessor.fromSlot((Slot)menu.getSlot(index))).collect(Collectors.toList());
    }
}

