/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.compat.top.provider;

import com.github.tartaricacid.touhoulittlemaid.api.event.AddTopInfoEvent;
import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import mcjty.theoneprobe.api.ElementAlignment;
import mcjty.theoneprobe.api.IProbeHitEntityData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoEntityProvider;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class MaidProvider
implements IProbeInfoEntityProvider {
    private static final String ID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"maid").toString();

    public void addProbeEntityInfo(ProbeMode probeMode, IProbeInfo probeInfo, Player playerEntity, Level world, Entity entity, IProbeHitEntityData iProbeHitEntityData) {
        if (entity instanceof EntityMaid) {
            EntityMaid maid = (EntityMaid)entity;
            if (maid.isTame()) {
                IMaidTask task = maid.getTask();
                MutableComponent taskTitle = Component.translatable((String)"top.touhou_little_maid.entity_maid.task").append((Component)task.getName());
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Component)taskTitle);
                NeoForge.EVENT_BUS.post((Event)new AddTopInfoEvent(maid, probeMode, probeInfo, iProbeHitEntityData));
                MutableComponent scheduleTitle = Component.translatable((String)"top.touhou_little_maid.entity_maid.schedule").append((Component)this.getActivityTransText(maid));
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Component)scheduleTitle);
                MutableComponent favorabilityTitle = Component.translatable((String)"top.touhou_little_maid.entity_maid.favorability", (Object[])new Object[]{maid.getFavorabilityManager().getLevel()});
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Component)favorabilityTitle);
                MutableComponent nextFavorabilityPointTitle = Component.translatable((String)"top.touhou_little_maid.entity_maid.nex_favorability_point", (Object[])new Object[]{maid.getFavorabilityManager().nextLevelPoint()});
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Component)nextFavorabilityPointTitle);
            }
            if (maid.getIsInvulnerable()) {
                MutableComponent text = Component.translatable((String)"top.touhou_little_maid.entity_maid.invulnerable").withStyle(ChatFormatting.DARK_PURPLE);
                probeInfo.horizontal(probeInfo.defaultLayoutStyle().alignment(ElementAlignment.ALIGN_CENTER)).text((Component)text);
            }
        }
    }

    public String getID() {
        return ID;
    }

    private MutableComponent getActivityTransText(EntityMaid maid) {
        return this.getActivityTransText(maid.getScheduleDetail());
    }

    private MutableComponent getActivityTransText(Activity activity) {
        return Component.translatable((String)("gui.touhou_little_maid.activity." + activity.getName()));
    }
}

