/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.attachment.AttachmentType;

public class PowerAttachment {
    public static final float MAX_POWER = 5.0f;
    public static final AttachmentType<PowerAttachment> TYPE = AttachmentType.builder(() -> new PowerAttachment(0.0f)).serialize(RecordCodecBuilder.create(ins -> ins.group((App)Codec.FLOAT.fieldOf("power").forGetter(o -> Float.valueOf(o.power))).apply((Applicative)ins, PowerAttachment::new))).build();
    private float power;

    public PowerAttachment(float power) {
        this.power = power;
    }

    public void add(float points) {
        this.power = points + this.power <= 5.0f ? (this.power += points) : 5.0f;
    }

    public void min(float points) {
        this.power = points <= this.power ? (this.power -= points) : 0.0f;
    }

    public void set(float points) {
        this.power = Mth.clamp((float)points, (float)0.0f, (float)5.0f);
    }

    public float get() {
        return this.power;
    }
}

