/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.item.ItemEntityPlaceholder;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ChallengeAdvancement {
    public static void generate(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        AdvancementHolder root = ChallengeAdvancement.make((ItemLike)Items.IRON_HELMET, "any_equipment").addCriterion("maid_event", MaidEventTrigger.create("any_equipment")).save(saver, ChallengeAdvancement.id("challenge/any_equipment"), existingFileHelper);
        ChallengeAdvancement.generateProtect(root, saver, existingFileHelper);
        ChallengeAdvancement.generateKill(root, saver, existingFileHelper);
    }

    private static void generateProtect(AdvancementHolder root, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        AdvancementHolder protect = ChallengeAdvancement.make((ItemLike)Items.ENCHANTED_GOLDEN_APPLE, "eat_enchanted_golden_apple").parent(root).addCriterion("maid_event", MaidEventTrigger.create("eat_enchanted_golden_apple")).save(saver, ChallengeAdvancement.id("challenge/eat_enchanted_golden_apple"), existingFileHelper);
        ChallengeAdvancement.makeChallenge((ItemLike)InitItems.ALL_NETHERITE_EQUIPMENT.get(), "all_netherite_equipment").parent(protect).rewards(AdvancementRewards.Builder.experience((int)50)).addCriterion("maid_event", MaidEventTrigger.create("all_netherite_equipment")).save(saver, ChallengeAdvancement.id("challenge/all_netherite_equipment"), existingFileHelper);
        ItemStack stack = ItemEntityPlaceholder.setRecipeId(new ItemStack((ItemLike)InitItems.ENTITY_PLACEHOLDER.get()), "spawn_lightning_bolt");
        AdvancementHolder lightningBolt = ChallengeAdvancement.make(stack, "lightning_bolt").parent(protect).addCriterion("maid_event", MaidEventTrigger.create("lightning_bolt")).save(saver, ChallengeAdvancement.id("challenge/lightning_bolt"), existingFileHelper);
        ChallengeAdvancement.makeGoal((ItemLike)InitItems.MAID_100_HEALTHY.get(), "maid_100_healthy").parent(lightningBolt).addCriterion("maid_event", MaidEventTrigger.create("maid_100_healthy")).save(saver, ChallengeAdvancement.id("challenge/maid_100_healthy"), existingFileHelper);
    }

    private static void generateKill(AdvancementHolder root, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        AdvancementHolder kill = ChallengeAdvancement.makeGoal((ItemLike)InitItems.KILL_100.get(), "kill_100").parent(root).addCriterion("maid_event", MaidEventTrigger.create("kill_100")).rewards(AdvancementRewards.Builder.experience((int)50)).save(saver, ChallengeAdvancement.id("challenge/kill_100"), existingFileHelper);
        ChallengeAdvancement.makeChallenge((ItemLike)InitItems.KILL_SLIME_300.get(), "kill_slime_300").parent(kill).addCriterion("maid_event", MaidEventTrigger.create("kill_slime_300")).rewards(AdvancementRewards.Builder.experience((int)50)).save(saver, ChallengeAdvancement.id("challenge/kill_slime_300"), existingFileHelper);
        AdvancementHolder wither = ChallengeAdvancement.makeChallenge((ItemLike)InitItems.KILL_WITHER.get(), "kill_wither").parent(kill).addCriterion("maid_event", MaidEventTrigger.create("kill_wither")).save(saver, ChallengeAdvancement.id("challenge/kill_wither"), existingFileHelper);
        ChallengeAdvancement.makeChallenge((ItemLike)InitItems.KILL_DRAGON.get(), "kill_dragon").parent(wither).addCriterion("maid_event", MaidEventTrigger.create("kill_dragon")).save(saver, ChallengeAdvancement.id("challenge/kill_dragon"), existingFileHelper);
    }

    private static void generateOther(AdvancementHolder root, Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        ChallengeAdvancement.makeGoal((ItemLike)Items.ENCHANTED_BOOK, "maid_fishing_enchanted_book").parent(root).addCriterion("maid_event", MaidEventTrigger.create("maid_fishing_enchanted_book")).save(saver, ChallengeAdvancement.id("challenge/maid_fishing_enchanted_book"), existingFileHelper);
        ChallengeAdvancement.makeGoal((ItemLike)Items.CAKE, "tamed_maid_in_pillager_outpost").parent(root).addCriterion("maid_event", MaidEventTrigger.create("tamed_maid_from_structure")).save(saver, ChallengeAdvancement.id("challenge/tamed_maid_in_pillager_outpost"), existingFileHelper);
    }

    private static Advancement.Builder make(ItemLike item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.challenge.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.TASK, true, true, false);
    }

    private static Advancement.Builder make(ItemStack item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.challenge.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.TASK, true, true, false);
    }

    private static Advancement.Builder makeGoal(ItemLike item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.challenge.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.GOAL, true, true, false);
    }

    private static Advancement.Builder makeChallenge(ItemLike item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.challenge.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.challenge.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.CHALLENGE, true, true, false);
    }

    private static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)id);
    }
}

