/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datagen.advancement;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class FavorabilityAdvancement {
    public static void generate(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper) {
        AdvancementHolder root = FavorabilityAdvancement.make((ItemLike)InitItems.BOOKSHELF.get(), "maid_sit_joy").addCriterion("maid_event", MaidEventTrigger.create("maid_sit_joy")).rewards(AdvancementRewards.Builder.experience((int)50)).save(saver, FavorabilityAdvancement.id("favorability/maid_sit_joy"), existingFileHelper);
        FavorabilityAdvancement.generateFavorability(saver, existingFileHelper, root);
        FavorabilityAdvancement.generateJoy(saver, existingFileHelper, root);
    }

    private static void generateJoy(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper, AdvancementHolder root) {
        AdvancementHolder joy = FavorabilityAdvancement.make((ItemLike)InitItems.PICNIC_BASKET.get(), "maid_picnic_eat").parent(root).addCriterion("maid_event", MaidEventTrigger.create("maid_picnic_eat")).save(saver, FavorabilityAdvancement.id("favorability/maid_picnic_eat"), existingFileHelper);
        AdvancementHolder gomoku = FavorabilityAdvancement.makeGoal((ItemLike)InitItems.GOMOKU.get(), "win_gomoku").parent(joy).addCriterion("maid_event", MaidEventTrigger.create("win_gomoku")).save(saver, FavorabilityAdvancement.id("favorability/win_gomoku"), existingFileHelper);
        AdvancementHolder cchess = FavorabilityAdvancement.makeGoal((ItemLike)InitItems.CCHESS.get(), "win_cchess").parent(gomoku).addCriterion("maid_event", MaidEventTrigger.create("win_cchess")).save(saver, FavorabilityAdvancement.id("favorability/win_cchess"), existingFileHelper);
        FavorabilityAdvancement.makeGoal((ItemLike)InitItems.WCHESS.get(), "win_wchess").parent(cchess).addCriterion("maid_event", MaidEventTrigger.create("win_wchess")).save(saver, FavorabilityAdvancement.id("favorability/win_wchess"), existingFileHelper);
        FavorabilityAdvancement.make((ItemLike)InitItems.MAID_BED.get(), "maid_sleep").parent(joy).addCriterion("maid_event", MaidEventTrigger.create("maid_sleep")).save(saver, FavorabilityAdvancement.id("favorability/maid_sleep"), existingFileHelper);
    }

    private static void generateFavorability(Consumer<AdvancementHolder> saver, ExistingFileHelper existingFileHelper, AdvancementHolder root) {
        AdvancementHolder increased = FavorabilityAdvancement.make((ItemLike)InitItems.FAVORABILITY_TOOL_ADD.get(), "favorability_increased").parent(root).addCriterion("maid_event", MaidEventTrigger.create("favorability_increased")).save(saver, FavorabilityAdvancement.id("favorability/favorability_increased"), existingFileHelper);
        FavorabilityAdvancement.makeGoal((ItemLike)InitItems.FAVORABILITY_TOOL_FULL.get(), "favorability_increased_max").parent(increased).addCriterion("maid_event", MaidEventTrigger.create("favorability_increased_max")).save(saver, FavorabilityAdvancement.id("favorability/favorability_increased_max"), existingFileHelper);
    }

    private static Advancement.Builder make(ItemLike item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.favorability.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.favorability.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.TASK, true, true, false);
    }

    private static Advancement.Builder makeGoal(ItemLike item, String key) {
        MutableComponent title = Component.translatable((String)String.format("advancements.touhou_little_maid.favorability.%s.title", key));
        MutableComponent desc = Component.translatable((String)String.format("advancements.touhou_little_maid.favorability.%s.description", key));
        return Advancement.Builder.advancement().display(item, (Component)title, (Component)desc, ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"textures/advancements/backgrounds/stone.png"), AdvancementType.GOAL, true, true, false);
    }

    private static ResourceLocation id(String id) {
        return ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)id);
    }
}

