/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datapack.resources;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.datapack.BoardStateData;
import com.github.tartaricacid.touhoulittlemaid.datapack.pojo.BoardStateRecord;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class BoardStateDataReloadListener
implements ResourceManagerReloadListener {
    private static final ResourceLocation CHESS_PATH = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"board_states/chess.json");
    private static final ResourceLocation XIANGQI_PATH = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"board_states/xiangqi.json");
    private static final ResourceLocation GOMOKU_PATH = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"board_states/gomoku.json");
    private static final Gson GSON = new Gson();

    public void onResourceManagerReload(ResourceManager resourceManager) {
        BoardStateData.clear();
        resourceManager.listPacks().forEach(packResources -> {
            BoardStateDataReloadListener.readData(packResources, CHESS_PATH, BoardStateData::addChessRecords);
            BoardStateDataReloadListener.readData(packResources, XIANGQI_PATH, BoardStateData::addXiangqiRecords);
            BoardStateDataReloadListener.readData(packResources, GOMOKU_PATH, BoardStateData::addGomokuRecords);
        });
    }

    private static void readData(PackResources packResources, ResourceLocation path, Consumer<List<BoardStateRecord>> adder) {
        IoSupplier resource = packResources.getResource(PackType.SERVER_DATA, path);
        if (resource == null) {
            return;
        }
        try (InputStream inputStream = (InputStream)resource.get();
             InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
            List records = (List)GSON.fromJson((Reader)reader, new TypeToken<List<BoardStateRecord>>(){}.getType());
            if (records != null && !records.isEmpty()) {
                adder.accept(records);
            }
        }
        catch (Exception e) {
            TouhouLittleMaid.LOGGER.error("Failed to load board state data from {}", (Object)path, (Object)e);
        }
    }
}

