/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.datapack.resources;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.datapack.KaomojiData;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class KaomojiDataReloadListener
implements ResourceManagerReloadListener {
    private static final ResourceLocation FILE_PATH = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"chat_bubble/kaomoji.json");
    private static final Gson GSON = new Gson();

    public void onResourceManagerReload(ResourceManager resourceManager) {
        KaomojiData.clear();
        resourceManager.listPacks().forEach(packResources -> {
            IoSupplier resource = packResources.getResource(PackType.SERVER_DATA, FILE_PATH);
            if (resource == null) {
                return;
            }
            try (InputStream inputStream = (InputStream)resource.get();
                 InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                Map data = (Map)GSON.fromJson((Reader)reader, new TypeToken<Map<String, List<String>>>(this){}.getType());
                if (data != null && !data.isEmpty()) {
                    KaomojiData.merge(data);
                }
            }
            catch (Exception e) {
                TouhouLittleMaid.LOGGER.error("Failed to load kaomoji data from {}", (Object)FILE_PATH, (Object)e);
            }
        });
    }
}

