/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.debug.target;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DebugTarget;
import com.github.tartaricacid.touhoulittlemaid.debug.target.DefaultTargets;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.VisibleForDebug;

@VisibleForDebug
public class DebugMaidManager {
    public static ConcurrentHashMap<UUID, Set<UUID>> PLAYER_DEBUGGING_MAID = new ConcurrentHashMap();
    public static ConcurrentHashMap<UUID, Set<UUID>> MAID_DEBUGGING_PLAYER = new ConcurrentHashMap();
    public static List<Function<EntityMaid, List<DebugTarget>>> DEBUG_TARGETS = new ArrayList<Function<EntityMaid, List<DebugTarget>>>();

    public static void init() {
        DEBUG_TARGETS.addAll(DefaultTargets.getDefaultTargets());
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            DEBUG_TARGETS.addAll(littleMaid.getMaidDebugTargets());
        }
    }

    public static List<DebugTarget> getDebugTargets(EntityMaid maid) {
        return DEBUG_TARGETS.stream().flatMap(f -> ((List)f.apply(maid)).stream()).toList();
    }

    public static List<ServerPlayer> getDebuggingPlayer(EntityMaid maid) {
        Set<UUID> playerId = MAID_DEBUGGING_PLAYER.get(maid.getUUID());
        if (playerId == null) {
            return List.of();
        }
        MinecraftServer server = maid.level.getServer();
        if (server == null) {
            return List.of();
        }
        return playerId.stream().map(uuid -> server.getPlayerList().getPlayer(uuid)).filter(Objects::nonNull).toList();
    }

    public static List<EntityMaid> getDebuggingMaid(ServerPlayer player) {
        Set<UUID> maidId = PLAYER_DEBUGGING_MAID.get(player.getUUID());
        if (maidId == null) {
            return List.of();
        }
        return maidId.stream().map(uuid -> player.serverLevel().getEntity(uuid)).filter(Objects::nonNull).filter(EntityMaid.class::isInstance).map(EntityMaid.class::cast).toList();
    }

    public static void setDebuggingMaid(ServerPlayer player, EntityMaid maid) {
        DebugMaidManager.removeDebuggingMaid(player, maid);
        PLAYER_DEBUGGING_MAID.computeIfAbsent(player.getUUID(), k -> new HashSet()).add(maid.getUUID());
        MAID_DEBUGGING_PLAYER.computeIfAbsent(maid.getUUID(), k -> new HashSet()).add(player.getUUID());
    }

    public static void removeDebuggingMaid(ServerPlayer player, EntityMaid maid) {
        if (PLAYER_DEBUGGING_MAID.containsKey(player.getUUID())) {
            PLAYER_DEBUGGING_MAID.get(player.getUUID()).remove(maid.getUUID());
        }
        if (MAID_DEBUGGING_PLAYER.containsKey(maid.getUUID())) {
            MAID_DEBUGGING_PLAYER.get(maid.getUUID()).remove(player.getUUID());
        }
    }

    public static void triggerDebuggingMaid(ServerPlayer player, EntityMaid maid) {
        if (PLAYER_DEBUGGING_MAID.containsKey(player.getUUID()) && PLAYER_DEBUGGING_MAID.get(player.getUUID()).contains(maid.getUUID())) {
            DebugMaidManager.removeDebuggingMaid(player, maid);
            player.sendSystemMessage((Component)Component.translatable((String)"debug.touhou_little_maid.debug_stick.show_path_finder.disable"));
        } else {
            DebugMaidManager.setDebuggingMaid(player, maid);
            player.sendSystemMessage((Component)Component.translatable((String)"debug.touhou_little_maid.debug_stick.show_path_finder.enable"));
        }
    }
}

