/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.sensor;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitEntities;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.phys.AABB;

public class MaidPickupEntitiesSensor
extends Sensor<EntityMaid> {
    public MaidPickupEntitiesSensor() {
        super(30);
    }

    public Set<MemoryModuleType<?>> requires() {
        return ImmutableSet.of(InitEntities.VISIBLE_PICKUP_ENTITIES.get());
    }

    protected void doTick(ServerLevel worldIn, EntityMaid maid) {
        if (!maid.isTame()) {
            return;
        }
        float radius = maid.getRestrictRadius();
        AABB aabb = maid.hasRestriction() ? new AABB(maid.getRestrictCenter()).inflate((double)radius, 4.0, (double)radius) : maid.getBoundingBox().inflate((double)radius, 4.0, (double)radius);
        List allEntities = worldIn.getEntitiesOfClass(Entity.class, aabb, Entity::isAlive);
        allEntities.sort(Comparator.comparingDouble(arg_0 -> ((EntityMaid)maid).distanceToSqr(arg_0)));
        List optional = allEntities.stream().filter(e -> maid.canPickup((Entity)e, true)).filter(e -> e.closerThan((Entity)maid, (double)(radius + 1.0f))).filter(e -> maid.isWithinRestriction(e.blockPosition())).filter(arg_0 -> ((EntityMaid)maid).hasLineOfSight(arg_0)).collect(Collectors.toList());
        maid.getBrain().setMemory(InitEntities.VISIBLE_PICKUP_ENTITIES.get(), optional);
    }
}

