/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class MaidClimbTask
extends Behavior<EntityMaid> {
    public MaidClimbTask() {
        super((Map)ImmutableMap.of());
    }

    protected void start(ServerLevel pLevel, EntityMaid maid, long pGameTime) {
        BlockPos.MutableBlockPos currentPosition = maid.blockPosition().mutable();
        Vec3 centerPos = Vec3.atCenterOf((Vec3i)currentPosition);
        maid.moveTo(centerPos.x, currentPosition.getY(), centerPos.z);
        maid.setDeltaMovement(0.0, maid.getDeltaMovement().y(), 0.0);
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, EntityMaid maid) {
        if (!maid.getConfigManager().isActiveClimbing()) {
            return false;
        }
        return maid.onClimbable();
    }

    protected boolean canStillUse(ServerLevel pLevel, EntityMaid pEntity, long pGameTime) {
        return this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void tick(ServerLevel level, EntityMaid maid, long pGameTime) {
        Node pointNext;
        Path path = maid.getNavigation().getPath();
        if (path == null || path.isDone()) {
            maid.setCanClimb(false);
            return;
        }
        maid.setCanClimb(true);
        int beGoNodeIndex = path.getNextNodeIndex();
        Node beGoNode = path.getNode(beGoNodeIndex);
        BlockPos maidFeetPos = maid.blockPosition();
        BlockState feetBlock = level.getBlockState(maidFeetPos);
        boolean up = true;
        if (beGoNodeIndex > 0) {
            Node currentNext = path.getNode(beGoNodeIndex - 1);
            pointNext = path.getNode(beGoNodeIndex);
            if (pointNext.y <= currentNext.y) {
                up = false;
            }
        }
        maid.setShiftKeyDown(!up);
        if (maidFeetPos.getY() <= beGoNode.y && up && feetBlock.isLadder((LevelReader)level, maidFeetPos, (LivingEntity)maid)) {
            yMotion0 = 1.0;
            yMotion = 0.25;
            maid.setDeltaMovement(0.0, yMotion0, 0.0);
            maid.setDeltaMovement(0.0, yMotion, 0.0);
        } else {
            yMotion0 = -1.0;
            yMotion = -0.25;
            maid.setDeltaMovement(0.0, yMotion0, 0.0);
            maid.setDeltaMovement(0.0, yMotion, 0.0);
        }
        if (!up && beGoNode.y != maidFeetPos.getY()) {
            int nodeCount = path.getNodeCount();
            for (int i1 = 0; i1 < nodeCount; ++i1) {
                Node node = path.getNode(i1);
                Node nextNode = path.getNode(Math.min(i1 + 1, nodeCount - 1));
                if (node.y != maidFeetPos.getY() || node.x != maidFeetPos.getX() || node.z != maidFeetPos.getZ() || node.y != nextNode.y) continue;
                beGoNodeIndex = i1;
                beGoNode = node;
                path.setNextNodeIndex(i1);
                break;
            }
        }
        if (beGoNode.y - maidFeetPos.getY() >= 0 && (double)(beGoNode.y - maidFeetPos.getY()) <= 1.2 && beGoNodeIndex + 1 < path.getNodeCount()) {
            boolean beWalkSurface;
            Node currentNext = path.getNode(beGoNodeIndex);
            pointNext = path.getNode(beGoNodeIndex + 1);
            boolean bl = beWalkSurface = pointNext.y == currentNext.y;
            if (beWalkSurface || pointNext == path.getEndNode() || maidFeetPos.getY() == currentNext.y) {
                maid.setCanClimb(false);
                int x1 = pointNext.x - currentNext.x;
                int z1 = pointNext.z - currentNext.z;
                double y = maid.getDeltaMovement().y();
                maid.setDeltaMovement(0.2, 1.0, 0.2);
                maid.setDeltaMovement((double)x1 * 0.3, y + 0.012, (double)z1 * 0.3);
                maid.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(pointNext.asVec3()));
            }
        }
    }

    protected void stop(ServerLevel pLevel, EntityMaid maid, long pGameTime) {
        maid.setShiftKeyDown(false);
        maid.setCanClimb(false);
    }
}

