/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.IPlayerMixin;
import com.github.tartaricacid.touhoulittlemaid.compat.gun.swarfare.SWarfareCompat;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.mixin.accessor.EntityAccessor;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class MaidFollowOwnerVehicleTask
extends Behavior<EntityMaid> {
    private static final int RANGE = 3;
    private final float speedModifier;
    private final int stopDistance;
    private Entity ownerControlledVehicle;
    private Type type = Type.NONE;

    public MaidFollowOwnerVehicleTask(float speedModifier, int stopDistance) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.stopDistance = stopDistance;
    }

    protected boolean checkExtraStartConditions(ServerLevel worldIn, EntityMaid maid) {
        if (!this.maidStateConditions(maid)) {
            return false;
        }
        LivingEntity owner = maid.getOwner();
        if (!this.ownerStateConditions(owner) || !(owner instanceof Player)) {
            return false;
        }
        Player player = (Player)owner;
        Entity ownerControlledVehicle = owner.getControlledVehicle();
        if (ownerControlledVehicle == null && SWarfareCompat.isVehicle(owner.getVehicle())) {
            ownerControlledVehicle = owner.getVehicle();
        }
        Entity maidVehicle = maid.getVehicle();
        if (ownerControlledVehicle == null) {
            boolean maidInDismountRange;
            boolean isCooldown = ((IPlayerMixin)player).tlmInRemoveVehicleCooldown();
            boolean bl = maidInDismountRange = maid.distanceTo((Entity)owner) < 3.0f;
            if (SWarfareCompat.isVehicle(maidVehicle)) {
                boolean bl2 = maidInDismountRange = maid.distanceTo((Entity)owner) < 9.0f;
            }
            if (maid.isPassenger() && isCooldown && maidInDismountRange) {
                this.type = Type.STOP;
                return true;
            }
            return false;
        }
        if (maidVehicle != null && maidVehicle == ownerControlledVehicle) {
            return false;
        }
        if (!((EntityAccessor)ownerControlledVehicle).tlmCanAddPassenger((Entity)maid)) {
            return false;
        }
        if (maid.closerThan(ownerControlledVehicle, 3.0)) {
            this.ownerControlledVehicle = ownerControlledVehicle;
            this.type = Type.RIDE;
            return true;
        }
        if (!maid.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET)) {
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)ownerControlledVehicle, (float)this.speedModifier, (int)this.stopDistance);
            return false;
        }
        return false;
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        switch (this.type.ordinal()) {
            case 0: {
                Optional.ofNullable(this.ownerControlledVehicle).ifPresent(arg_0 -> ((EntityMaid)maid).startRiding(arg_0));
                break;
            }
            case 1: {
                maid.stopRiding();
            }
        }
    }

    protected void stop(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        this.ownerControlledVehicle = null;
        this.type = Type.NONE;
    }

    private boolean canBrainMoving(EntityMaid maid) {
        return !maid.isMaidInSittingPose() && !maid.isSleeping() && !maid.isLeashed();
    }

    private boolean maidStateConditions(EntityMaid maid) {
        return !maid.isHomeModeEnable() && this.canBrainMoving(maid) && maid.isRideable();
    }

    private boolean ownerStateConditions(@Nullable LivingEntity owner) {
        return owner != null && owner.isAlive() && !owner.isSpectator() && !owner.isDeadOrDying();
    }

    static enum Type {
        RIDE,
        STOP,
        NONE;

    }
}

