/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidCheckRateTask;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.neoforged.neoforge.common.IShearable;

public class MaidShearTask
extends MaidCheckRateTask {
    private static final int MAX_DELAY_TIME = 12;
    private final float speedModifier;
    private LivingEntity shearableEntity = null;

    public MaidShearTask(float speedModifier) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.VALUE_ABSENT));
        this.speedModifier = speedModifier;
        this.setMaxCheckRate(12);
    }

    protected void start(ServerLevel worldIn, EntityMaid maid, long gameTimeIn) {
        ItemStack mainHandItem = maid.getMainHandItem();
        this.shearableEntity = null;
        if (!(mainHandItem.getItem() instanceof ShearsItem)) {
            return;
        }
        this.getEntities(maid).find(e -> maid.isWithinRestriction(e.blockPosition())).filter(Entity::isAlive).filter(e -> e instanceof IShearable).filter(e -> ((IShearable)e).isShearable(null, mainHandItem, maid.level(), e.blockPosition())).filter(maid::canPathReach).findFirst().ifPresent(e -> {
            this.shearableEntity = e;
            BehaviorUtils.setWalkAndLookTargetMemories((LivingEntity)maid, (Entity)e, (float)this.speedModifier, (int)0);
        });
        if (this.shearableEntity != null && this.shearableEntity.closerThan((Entity)maid, 2.0)) {
            RandomSource rand = maid.getRandom();
            List drops = ((IShearable)this.shearableEntity).onSheared(null, mainHandItem, maid.level(), this.shearableEntity.blockPosition());
            drops.forEach(stack -> {
                ItemEntity itemEntity = this.shearableEntity.spawnAtLocation(stack, 1.0f);
                if (itemEntity != null) {
                    itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f)));
                }
            });
            maid.swing(InteractionHand.MAIN_HAND);
            mainHandItem.hurtAndBreak(1, (LivingEntity)maid, EquipmentSlot.MAINHAND);
            this.shearableEntity = null;
        }
    }

    private NearestVisibleLivingEntities getEntities(EntityMaid maid) {
        return maid.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).orElse(NearestVisibleLivingEntities.empty());
    }
}

