/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.goal;

import com.github.tartaricacid.touhoulittlemaid.datagen.tag.EntityTypeGenerator;
import com.github.tartaricacid.touhoulittlemaid.entity.monster.EntityFairy;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class FairyNearestAttackableTargetGoal<T extends LivingEntity>
extends TargetGoal {
    private static final int DEFAULT_RANDOM_INTERVAL = 5;
    private final TargetingConditions targetConditions;
    @Nullable
    private LivingEntity target;

    public FairyNearestAttackableTargetGoal(EntityFairy fairy) {
        super((Mob)fairy, true, false);
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
        this.targetConditions = TargetingConditions.forCombat().range(this.getFollowDistance());
    }

    public boolean canUse() {
        if (this.mob.getRandom().nextInt(5) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    private AABB getTargetSearchArea(double distance) {
        return this.mob.getBoundingBox().inflate(distance, 4.0, distance);
    }

    private void findTarget() {
        Level level = this.mob.level;
        AABB searchArea = this.getTargetSearchArea(this.getFollowDistance());
        List entities = level.getEntitiesOfClass(LivingEntity.class, searchArea, e -> e.getType().is(EntityTypeGenerator.MAID_FAIRY_ATTACK_GOAL));
        this.target = level.getNearestEntity(entities, this.targetConditions, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
    }

    public void start() {
        this.mob.setTarget(this.target);
        super.start();
    }
}

