/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.INodeCacheEvaluator;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.NodeNeighborCache;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MaidNodeEvaluator
extends WalkNodeEvaluator
implements INodeCacheEvaluator {
    boolean noValidation = false;

    public void prepare(PathNavigationRegion level, Mob mob) {
        EntityMaid maid;
        Level level2;
        super.prepare(level, mob);
        if (mob instanceof EntityMaid && (level2 = (maid = (EntityMaid)mob).level()) instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level2;
            BlockPos pos = maid.hasRestriction() ? maid.getRestrictCenter() : maid.blockPosition();
            int restrictRadius = maid.hasRestriction() ? (int)maid.getRestrictRadius() : 5;
            int tickCount = sl.getServer().getTickCount();
            if (maid.nodeNeighborCache != null && maid.nodeNeighborCache.tickCount == tickCount) {
                return;
            }
            Optional min = mob.level().getEntities(EntityTypeTest.forClass(EntityMaid.class), new AABB(pos).inflate((double)restrictRadius), m -> m.nodeNeighborCache != null && m.nodeNeighborCache.tickCount == tickCount).stream().min((t, t2) -> (int)(t.distanceTo((Entity)maid) - t2.distanceTo((Entity)maid)));
            maid.nodeNeighborCache = min.map(entityMaid -> NodeNeighborCache.copyToAnotherCenter(entityMaid.nodeNeighborCache, pos.getX(), pos.getY(), pos.getZ())).orElseGet(() -> new NodeNeighborCache(pos.getX(), pos.getY(), pos.getZ(), restrictRadius, 10, restrictRadius, tickCount));
        }
    }

    public PathType getPathType(PathfindingContext pContext, int pX, int pY, int pZ) {
        return this.getMaidBlockPathTypeStatic(pContext, new BlockPos.MutableBlockPos(pX, pY, pZ));
    }

    public int getNeighbors(Node[] outputArray, Node node) {
        EntityMaid maid;
        int nodeId = -1;
        Mob mob = this.mob;
        if (mob instanceof EntityMaid) {
            maid = (EntityMaid)mob;
            nodeId = maid.nodeNeighborCache.get(node, outputArray, this);
        }
        if (nodeId == -1) {
            this.noValidation = true;
            nodeId = super.getNeighbors(outputArray, node);
            this.noValidation = false;
            mob = this.mob;
            if (mob instanceof EntityMaid) {
                maid = (EntityMaid)mob;
                maid.nodeNeighborCache.record(node, outputArray, nodeId);
            }
        }
        int offset = 0;
        for (int i = 0; i < nodeId; ++i) {
            if (!this.isNeighborValid(outputArray[i], node)) {
                ++offset;
                continue;
            }
            if (offset == 0) continue;
            outputArray[i - offset] = outputArray[i];
        }
        if (offset != 0) {
            nodeId -= offset;
        }
        return this.createClimbNode(nodeId, outputArray, node);
    }

    protected boolean isNeighborValid(@Nullable Node neighbor, Node node) {
        if (neighbor != null && this.noValidation) {
            return true;
        }
        return super.isNeighborValid(neighbor, node);
    }

    protected int createClimbNode(int nodeId, Node[] nodes, Node origin) {
        EntityMaid maid;
        Mob mob = this.mob;
        if (mob instanceof EntityMaid && (maid = (EntityMaid)mob).getConfigManager().isActiveClimbing()) {
            BlockPos.MutableBlockPos downPos;
            BlockPos.MutableBlockPos upPos = new BlockPos.MutableBlockPos(origin.x, origin.y + 1, origin.z);
            if (MaidNodeEvaluator.isMaidCanClimbBlock((BlockPos)upPos, maid)) {
                Node node = this.getNode((BlockPos)upPos);
                if (!node.closed) {
                    node.costMalus = 0.0f;
                    node.type = PathType.WALKABLE;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
            if (MaidNodeEvaluator.isMaidCanClimbBlock((BlockPos)(downPos = new BlockPos.MutableBlockPos(origin.x, origin.y - 1, origin.z)), maid)) {
                Node node = this.getNode((BlockPos)downPos);
                if (!node.closed) {
                    node.costMalus = 0.0f;
                    node.type = PathType.WALKABLE;
                    if (nodeId + 1 < nodes.length) {
                        nodes[nodeId++] = node;
                    }
                }
            }
        }
        return nodeId;
    }

    private PathType getMaidBlockPathTypeStatic(PathfindingContext context, BlockPos.MutableBlockPos pos) {
        int z;
        int y;
        int x = pos.getX();
        PathType pathType = this.getMaidBlockPathTypeRaw(context, x, y = pos.getY(), z = pos.getZ());
        if (pathType == PathType.OPEN && y >= context.level().getMinBuildHeight() + 1) {
            return switch (this.getMaidBlockPathTypeRaw(context, x, y - 1, z)) {
                case PathType.OPEN, PathType.WATER, PathType.LAVA, PathType.WALKABLE -> PathType.OPEN;
                case PathType.DAMAGE_FIRE -> PathType.DAMAGE_FIRE;
                case PathType.DAMAGE_OTHER -> PathType.DAMAGE_OTHER;
                case PathType.STICKY_HONEY -> PathType.STICKY_HONEY;
                case PathType.POWDER_SNOW -> PathType.DANGER_POWDER_SNOW;
                case PathType.DAMAGE_CAUTIOUS -> PathType.DAMAGE_CAUTIOUS;
                case PathType.TRAPDOOR -> PathType.DANGER_TRAPDOOR;
                default -> MaidNodeEvaluator.checkNeighbourBlocks((PathfindingContext)context, (int)x, (int)y, (int)z, (PathType)PathType.WALKABLE);
            };
        }
        return pathType;
    }

    private PathType getMaidBlockPathTypeRaw(PathfindingContext context, int pX, int pY, int pZ) {
        EntityMaid maid;
        Mob mob;
        PathType pathType;
        EntityMaid maid2;
        BlockPos pos = new BlockPos(pX, pY, pZ);
        Mob mob2 = this.mob;
        if (mob2 instanceof EntityMaid && (maid2 = (EntityMaid)mob2).isWithinRestriction() && !maid2.isWithinRestriction(pos)) {
            return PathType.BLOCKED;
        }
        BlockState blockState = context.getBlockState(pos);
        if (blockState.getBlock() instanceof FenceGateBlock) {
            pathType = (Boolean)blockState.getValue((Property)FenceGateBlock.OPEN) != false ? PathType.DOOR_OPEN : PathType.DOOR_WOOD_CLOSED;
        } else {
            mob = this.mob;
            if (mob instanceof EntityMaid && this.canClimb(blockState, pos, maid = (EntityMaid)mob)) {
                pathType = PathType.WALKABLE;
            } else {
                pathType = context.getPathTypeFromState(pX, pY, pZ);
                if (!this.heightCheckExclusions(pathType) && this.mob != null) {
                    VoxelShape shape = blockState.getCollisionShape((BlockGetter)this.mob.level, pos);
                    if (pathType != PathType.BLOCKED && shape.max(Direction.Axis.Y) - shape.min(Direction.Axis.Y) > 0.5) {
                        pathType = PathType.BLOCKED;
                    }
                }
            }
        }
        if (pathType == PathType.DOOR_WOOD_CLOSED && (mob = this.mob) instanceof EntityMaid) {
            maid = (EntityMaid)mob;
            if (!this.canOpenDoor(blockState.getBlock(), maid)) {
                pathType = PathType.DOOR_IRON_CLOSED;
            }
        }
        return pathType;
    }

    private boolean heightCheckExclusions(PathType pathType) {
        return pathType == PathType.DOOR_OPEN || pathType == PathType.DOOR_WOOD_CLOSED;
    }

    private boolean canOpenDoor(Block block, EntityMaid maid) {
        if (block instanceof DoorBlock) {
            return maid.getConfigManager().isOpenDoor();
        }
        if (block instanceof FenceGateBlock) {
            return maid.getConfigManager().isOpenFenceGate();
        }
        return true;
    }

    private boolean canClimb(BlockState blockState, BlockPos blockPos, EntityMaid maid) {
        if (MaidNodeEvaluator.isMaidCanClimbBlock(blockState, blockPos, maid)) {
            return maid.getConfigManager().isActiveClimbing();
        }
        return false;
    }

    public static boolean isMaidCanClimbBlock(BlockPos blockPos, EntityMaid maid) {
        Level level = maid.level;
        BlockState blockState = level.getBlockState(blockPos);
        return MaidNodeEvaluator.isMaidCanClimbBlock(blockState, blockPos, maid);
    }

    public static boolean isMaidCanClimbBlock(BlockState blockState, BlockPos blockPos, EntityMaid maid) {
        return blockState.isLadder((LevelReader)maid.level, blockPos, (LivingEntity)maid);
    }

    @Override
    public Node createNode(int x, int y, int z) {
        return this.getNode(x, y, z);
    }
}

