/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.ICachedEvaluator;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.INodeCacheEvaluator;
import com.github.tartaricacid.touhoulittlemaid.util.CenterOffsetBlockPosSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.AmphibiousNodeEvaluator;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public class MaidUnderWaterNodeEvaluator
extends AmphibiousNodeEvaluator
implements ICachedEvaluator,
INodeCacheEvaluator {
    protected CenterOffsetBlockPosSet vis;

    public MaidUnderWaterNodeEvaluator() {
        super(true);
    }

    public void prepare(PathNavigationRegion pLevel, Mob pMob) {
        super.prepare(pLevel, pMob);
    }

    public void done() {
        super.done();
        this.vis = null;
    }

    public Node getStart() {
        int x = Mth.floor((double)this.mob.getBoundingBox().minX);
        int y = Mth.floor((double)(this.mob.getBoundingBox().minY + 0.5));
        int z = Mth.floor((double)this.mob.getBoundingBox().minZ);
        return this.getStartNode(new BlockPos(x, y, z));
    }

    @Override
    public void init(int x, int y, int z, int cx, int cy, int cz) {
        this.vis = new CenterOffsetBlockPosSet(x, y, z, cx, cy, cz);
    }

    @Override
    public void markVis(BlockPos pPos) {
        this.vis.markVis(pPos);
    }

    public int getNeighbors(Node[] outputArray, Node node) {
        int nodeId = super.getNeighbors(outputArray, node);
        BlockPos blockPos = node.asBlockPos();
        if (this.mob.level.getFluidState(blockPos).is(FluidTags.WATER) && this.mob.level.getFluidState(blockPos.above()).isEmpty()) {
            Node aboveNode = this.getNode(node.x, node.y + 1, node.z);
            if (!aboveNode.closed) {
                aboveNode.costMalus += 1.0f;
                outputArray[nodeId++] = aboveNode;
            }
        }
        return nodeId;
    }

    protected boolean isNeighborValid(@Nullable Node neighbor, Node node) {
        if (neighbor != null && this.vis != null && this.vis.isVis(neighbor.asBlockPos())) {
            return false;
        }
        BlockPos blockPos = node.asBlockPos();
        if (neighbor != null && this.mob.level.getFluidState(blockPos).is(FluidTags.WATER) && this.mob.level.getFluidState(neighbor.asBlockPos()).isEmpty() && node.y != neighbor.y && (node.x != neighbor.x || node.z != neighbor.z)) {
            return false;
        }
        return super.isNeighborValid(neighbor, node);
    }

    @Nullable
    protected Node findAcceptedNode(int pX, int pY, int pZ, int verticalDeltaLimit, double nodeFloorLevel, Direction direction, PathType pathType) {
        if (this.vis != null && this.vis.isVis(pX, pY, pZ)) {
            return null;
        }
        return super.findAcceptedNode(pX, pY, pZ, verticalDeltaLimit, nodeFloorLevel, direction, pathType);
    }

    @Override
    public Node createNode(int x, int y, int z) {
        return this.getNode(x, y, z);
    }
}

