/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.ai.path;

import com.github.tartaricacid.touhoulittlemaid.entity.ai.path.MaidUnderWaterBoardingPathFinder;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.path.MaidWrappedPathFinder;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.Nullable;

public class MaidSelectivePathFinding
extends MaidWrappedPathFinder {
    private final MaidUnderWaterBoardingPathFinder boarding;
    private final BlockGetter level;

    public MaidSelectivePathFinding(NodeEvaluator nodeEvaluator, int maxVisitedNodes, BlockGetter level) {
        super(nodeEvaluator, maxVisitedNodes);
        this.level = level;
        this.boarding = new MaidUnderWaterBoardingPathFinder(nodeEvaluator, maxVisitedNodes);
    }

    @Override
    @Nullable
    public Path findPath(PathNavigationRegion region, Mob mob, Set<BlockPos> targetPositions, float maxRange, int accuracy, float searchDepthMultiplier) {
        if (targetPositions.stream().anyMatch(p -> this.level.getFluidState(p).isEmpty())) {
            return this.boarding.findPath(region, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
        }
        return super.findPath(region, mob, targetPositions, maxRange, accuracy, searchDepthMultiplier);
    }
}

