/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.data;

import com.github.tartaricacid.touhoulittlemaid.TouhouLittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.ILittleMaid;
import com.github.tartaricacid.touhoulittlemaid.api.entity.data.TaskDataKey;
import com.github.tartaricacid.touhoulittlemaid.init.InitTaskData;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.Logger;

public class TaskDataRegister {
    private static final Map<ResourceLocation, TaskDataKey<?>> MAPS = Maps.newHashMap();

    public static void init() {
        TaskDataRegister register = new TaskDataRegister();
        InitTaskData.registerAll(register);
        for (ILittleMaid littleMaid : TouhouLittleMaid.EXTENSIONS) {
            littleMaid.registerTaskData(register);
        }
    }

    public static <T> TaskDataKey<T> getValue(ResourceLocation key) {
        return MAPS.get(key);
    }

    public <T> TaskDataKey<T> register(ResourceLocation key, Codec<T> codec) {
        return this.register(key, codec, codec);
    }

    public <T> TaskDataKey<T> register(final ResourceLocation key, final Codec<T> saveCodec, final Codec<T> syncCodec) {
        TaskDataKey value = new TaskDataKey<T>(this){

            @Override
            public ResourceLocation getKey() {
                return key;
            }

            @Override
            public CompoundTag writeSaveData(T data) {
                return saveCodec.encodeStart((DynamicOps)NbtOps.INSTANCE, data).resultOrPartial(arg_0 -> ((Logger)TouhouLittleMaid.LOGGER).error(arg_0)).map(tag -> (CompoundTag)tag).orElse(new CompoundTag());
            }

            @Override
            public T readSaveData(CompoundTag compound) {
                return saveCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound).resultOrPartial(arg_0 -> ((Logger)TouhouLittleMaid.LOGGER).error(arg_0)).orElse(null);
            }

            @Override
            public CompoundTag writeSyncData(T data) {
                return syncCodec.encodeStart((DynamicOps)NbtOps.INSTANCE, data).resultOrPartial(arg_0 -> ((Logger)TouhouLittleMaid.LOGGER).error(arg_0)).map(tag -> (CompoundTag)tag).orElse(new CompoundTag());
            }

            @Override
            public T readSyncData(CompoundTag compound) {
                return syncCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound).resultOrPartial(arg_0 -> ((Logger)TouhouLittleMaid.LOGGER).error(arg_0)).orElse(null);
            }
        };
        return this.register(value);
    }

    public <T> TaskDataKey<T> register(TaskDataKey<T> value) {
        MAPS.put(value.getKey(), value);
        return value;
    }
}

