/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;

public abstract class AbstractEntityFromItem
extends LivingEntity {
    public AbstractEntityFromItem(EntityType<? extends LivingEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected abstract boolean canKillEntity(Player var1);

    protected abstract SoundEvent getHitSound();

    protected abstract Item getWithItem();

    protected abstract ItemStack getKilledStack();

    public boolean hurt(@Nonnull DamageSource source, float amount) {
        if (!this.level().isClientSide && !this.dead && this.isAlive()) {
            if (this.isInvulnerableTo(source)) {
                return false;
            }
            if (source.getDirectEntity() instanceof Player) {
                return this.applyHitEntityLogic((Player)source.getDirectEntity());
            }
        }
        return false;
    }

    private boolean applyHitEntityLogic(Player player) {
        if (player.isShiftKeyDown()) {
            this.ejectPassengers();
            this.playSound(this.getHitSound(), 1.0f, 1.0f);
            if (player.isCreative() || this.canKillEntity(player)) {
                this.killEntity();
            }
        }
        return true;
    }

    private void killEntity() {
        this.discard();
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            ItemStack itemstack = this.getKilledStack();
            if (this.hasCustomName()) {
                itemstack.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
            }
            this.spawnAtLocation(itemstack, 0.0f);
            this.dropExtraItems();
        }
    }

    protected void dropExtraItems() {
    }

    public void push(Entity entityIn) {
    }

    protected void doPush(Entity entity) {
    }

    public boolean isPushable() {
        return false;
    }

    public void kill() {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent((Holder)GameEvent.ENTITY_DIE);
    }

    public boolean skipAttackInteraction(Entity entity) {
        return entity instanceof Player && !this.level.mayInteract((Player)entity, this.blockPosition());
    }

    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public boolean showVehicleHealth() {
        return false;
    }

    public boolean isAffectedByPotions() {
        return false;
    }

    public void knockback(double strength, double ratioX, double ratioZ) {
    }

    @Nonnull
    public ItemStack getPickedResult(HitResult target) {
        return this.getKilledStack();
    }

    public boolean attackable() {
        return false;
    }

    public Iterable<ItemStack> getArmorSlots() {
        return Collections.emptyList();
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        return ItemStack.EMPTY;
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
    }

    public HumanoidArm getMainArm() {
        return HumanoidArm.LEFT;
    }
}

