/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.network.NetworkHandler;
import com.github.tartaricacid.touhoulittlemaid.network.message.BeaconAbsorbPackage;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncDataPackage;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.PacketDistributor;

public class EntityPowerPoint
extends Entity
implements IEntityWithComplexSpawn {
    public static final EntityType<EntityPowerPoint> TYPE = EntityType.Builder.of(EntityPowerPoint::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.5f).clientTrackingRange(6).updateInterval(20).build("power_point");
    private static final int MAX_AGE = 6000;
    public int tickCount;
    public int age;
    public int throwTime;
    public int value;
    private int health = 5;
    private Player followingPlayer;
    private int followingTime;

    public EntityPowerPoint(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntityPowerPoint(Level worldIn, double x, double y, double z, int powerValue) {
        this(TYPE, worldIn);
        this.setPos(x, y, z);
        this.setYRot((float)(this.random.nextDouble() * 360.0));
        this.setDeltaMovement((this.random.nextDouble() * 0.2 - 0.1) * 2.0, this.random.nextDouble() * 0.2 * 2.0, (this.random.nextDouble() * 0.2 - 0.1) * 2.0);
        this.value = powerValue;
    }

    public static int getPowerValue(int powerValue) {
        if (powerValue >= 485) {
            return 485;
        }
        if (powerValue >= 385) {
            return 385;
        }
        if (powerValue >= 285) {
            return 285;
        }
        if (powerValue >= 185) {
            return 185;
        }
        if (powerValue >= 89) {
            return 89;
        }
        if (powerValue >= 36) {
            return 34;
        }
        if (powerValue >= 17) {
            return 13;
        }
        if (powerValue >= 7) {
            return 7;
        }
        if (powerValue >= 5) {
            return 5;
        }
        return powerValue >= 3 ? 3 : 1;
    }

    public static int transPowerValueToXpValue(int powerValue) {
        return powerValue / 4;
    }

    public static void spawnExplosionParticle(Level world, float x, float y, float z, RandomSource rand) {
        if (!world.isClientSide) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            float mx = (rand.nextFloat() - 0.5f) * 0.02f;
            float my = (rand.nextFloat() - 0.5f) * 0.02f;
            float mz = (rand.nextFloat() - 0.5f) * 0.02f;
            world.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)(x + rand.nextFloat() - 0.5f), (double)(y + rand.nextFloat() - 0.5f), (double)(z + rand.nextFloat() - 0.5f), (double)mx, (double)my, (double)mz);
        }
    }

    public void spawnExplosionParticle() {
        float x = (float)this.position().x;
        float y = (float)this.position().y + 0.125f;
        float z = (float)this.position().z;
        if (this.level.isClientSide) {
            EntityPowerPoint.spawnExplosionParticle(this.level, x, y, z, this.random);
        } else {
            NetworkHandler.sendToNearby(this, new BeaconAbsorbPackage(x, y, z));
        }
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.throwTime > 0) {
            --this.throwTime;
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.fluidMovement();
        if (!this.level.noCollision(this.getBoundingBox())) {
            this.moveTowardsClosestSpace(this.getX(), (this.getBoundingBox().minY + this.getBoundingBox().maxY) / 2.0, this.getZ());
        }
        this.followingMovement();
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.groundMovement();
        ++this.tickCount;
        ++this.age;
        if (this.age >= 6000) {
            this.discard();
        }
    }

    private void groundMovement() {
        double slipperiness = 0.98;
        if (this.onGround()) {
            BlockPos pos = new BlockPos((int)this.getX(), (int)(this.getY() - 1.0), (int)this.getZ());
            slipperiness = (double)this.level.getBlockState(pos).getFriction((LevelReader)this.level, pos, (Entity)this) * 0.98;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply(slipperiness, 0.98, slipperiness));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
    }

    private void followingMovement() {
        Vec3 relativeVector;
        double length;
        double distance = 8.0;
        if (this.followingTime < this.getRandomCheckTime()) {
            if (this.followingPlayer == null || (double)this.followingPlayer.distanceTo((Entity)this) > distance) {
                this.followingPlayer = this.level.getNearestPlayer((Entity)this, distance);
            }
            this.followingTime = this.tickCount;
        }
        if (this.followingPlayer != null && this.followingPlayer.isSpectator()) {
            this.followingPlayer = null;
        }
        if (this.followingPlayer != null && (length = (relativeVector = new Vec3(this.followingPlayer.getX() - this.getX(), this.followingPlayer.getY() + (double)this.followingPlayer.getEyeHeight() / 2.0 - this.getY(), this.followingPlayer.getZ() - this.getZ())).length()) < distance) {
            double factor = 1.0 - length / 8.0;
            this.setDeltaMovement(this.getDeltaMovement().add(relativeVector.normalize().scale(factor * factor * 0.1)));
        }
    }

    private int getRandomCheckTime() {
        return this.tickCount - 20 + this.getId() % 100;
    }

    private void fluidMovement() {
        if (this.isEyeInFluid(FluidTags.WATER)) {
            Vec3 movement = this.getDeltaMovement();
            this.setDeltaMovement(movement.x * 0.99, Math.min(movement.y + 5.0E-4, 0.06), movement.z * 0.99);
        } else if (!this.isNoGravity()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        }
        if (this.level.getFluidState(this.blockPosition()).is(FluidTags.LAVA)) {
            this.setDeltaMovement((this.random.nextDouble() - this.random.nextDouble()) * 0.2, 0.2, (this.random.nextDouble() - this.random.nextDouble()) * 0.2);
            this.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
    }

    protected void doWaterSplashEffect() {
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.level.isClientSide || !this.isAlive()) {
            return false;
        }
        if (!this.isInvulnerableTo(source)) {
            this.markHurt();
            this.health = (int)((float)this.health - amount);
            if (this.health <= 0) {
                this.discard();
            }
        }
        return false;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putShort("Health", (short)this.health);
        compound.putShort("Age", (short)this.age);
        compound.putShort("Value", (short)this.value);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        this.health = compound.getShort("Health");
        this.age = compound.getShort("Age");
        this.value = compound.getShort("Value");
    }

    public void playerTouch(Player player) {
        if (this.level.isClientSide) {
            return;
        }
        if (this.throwTime == 0 && player.takeXpDelay == 0) {
            PowerAttachment power = (PowerAttachment)player.getData(InitDataAttachment.POWER_NUM);
            MaidNumAttachment maidNum = (MaidNumAttachment)player.getData(InitDataAttachment.MAID_NUM);
            player.takeXpDelay = 2;
            this.take((Entity)player, 1);
            if (this.value > 0) {
                if (power.get() + (float)this.value / 100.0f > 5.0f) {
                    power.add(5.0f - power.get());
                    int residualValue = this.value - 500 + (int)(power.get() * 100.0f);
                    player.giveExperiencePoints(EntityPowerPoint.transPowerValueToXpValue(residualValue));
                    player.setData(InitDataAttachment.POWER_NUM, (Object)new PowerAttachment(power.get()));
                } else {
                    power.add((float)this.value / 100.0f);
                    player.setData(InitDataAttachment.POWER_NUM, (Object)new PowerAttachment(power.get()));
                }
            }
            PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)player), (CustomPacketPayload)new SyncDataPackage(power.get(), maidNum.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.discard();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "pickup_power_point");
            }
        }
    }

    public void take(Entity player, int quantity) {
        if (this.isAlive() && !this.level.isClientSide) {
            ((ServerLevel)this.level).getChunkSource().broadcast((Entity)this, (Packet)new ClientboundTakeItemEntityPacket(this.getId(), player.getId(), quantity));
        }
    }

    public int getValue() {
        return this.value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getIcon() {
        if (this.value >= 485) {
            return 10;
        }
        if (this.value >= 385) {
            return 9;
        }
        if (this.value >= 285) {
            return 8;
        }
        if (this.value >= 185) {
            return 7;
        }
        if (this.value >= 89) {
            return 6;
        }
        if (this.value >= 36) {
            return 5;
        }
        if (this.value >= 17) {
            return 4;
        }
        if (this.value >= 7) {
            return 3;
        }
        if (this.value >= 5) {
            return 2;
        }
        return this.value >= 3 ? 1 : 0;
    }

    public boolean isAttackable() {
        return false;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.value);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.value = additionalData.readInt();
    }
}

