/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.item;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.favorability.FavorabilityManager;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.StringUtils;

public class EntitySit
extends Entity {
    public static final EntityType<EntitySit> TYPE = EntityType.Builder.of(EntitySit::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.1f).clientTrackingRange(10).ridingOffset(-0.25f).build("sit");
    private static final EntityDataAccessor<String> SIT_TYPE = SynchedEntityData.defineId(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private int passengerTick = 0;
    private BlockPos associatedBlockPos = BlockPos.ZERO;

    public EntitySit(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public EntitySit(Level worldIn, Vec3 pos, String joyType, BlockPos associatedBlockPos) {
        this(TYPE, worldIn);
        this.setPos(pos);
        this.setJoyType(joyType);
        this.associatedBlockPos = associatedBlockPos;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SIT_TYPE, (Object)"");
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("SitJoyType", 8)) {
            this.setJoyType(tag.getString("SitJoyType"));
        }
        if (tag.contains("AssociatedBlockPos", 11)) {
            Optional blockPosOptional = NbtUtils.readBlockPos((CompoundTag)tag, (String)"AssociatedBlockPos");
            blockPosOptional.ifPresent(blockPos -> {
                this.associatedBlockPos = blockPos;
            });
        }
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        if (StringUtils.isNotBlank((CharSequence)this.getJoyType())) {
            tag.putString("SitJoyType", this.getJoyType());
        }
        tag.put("AssociatedBlockPos", NbtUtils.writeBlockPos((BlockPos)this.associatedBlockPos));
    }

    public void tick() {
        if (!this.level.isClientSide) {
            this.checkBelowWorld();
            this.checkPassengers();
            Entity entity = this.getFirstPassenger();
            if (entity instanceof EntityMaid) {
                EntityMaid maid = (EntityMaid)entity;
                this.tickMaid(maid);
            }
        }
    }

    private void tickMaid(EntityMaid maid) {
        maid.setYRot(this.getYRot());
        maid.setYHeadRot(this.getYRot());
        if (this.tickCount % 20 == 0) {
            FavorabilityManager manager = maid.getFavorabilityManager();
            String joyType = this.getJoyType();
            IMaidTask task = maid.getTask();
            manager.apply(joyType);
            if (this.isIdleSchedule(maid)) {
                return;
            }
            if (this.isWorkSchedule(maid) && task.canSitInJoy(maid, joyType)) {
                return;
            }
            maid.stopRiding();
        }
    }

    private void checkPassengers() {
        this.passengerTick = this.getPassengers().isEmpty() ? ++this.passengerTick : 0;
        if (this.passengerTick > 10) {
            this.discard();
        }
    }

    private boolean isIdleSchedule(EntityMaid maid) {
        return maid.getScheduleDetail() == Activity.IDLE;
    }

    private boolean isWorkSchedule(EntityMaid maid) {
        return maid.getScheduleDetail() == Activity.WORK;
    }

    public BlockPos getAssociatedBlockPos() {
        return this.associatedBlockPos;
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions dimensions, float partialTick) {
        return new Vec3(0.0, -0.125, 0.0);
    }

    public boolean skipAttackInteraction(Entity pEntity) {
        return true;
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        return false;
    }

    public void move(MoverType pType, Vec3 pPos) {
    }

    public void push(Entity entity) {
    }

    public void push(double pX, double pY, double pZ) {
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    public void thunderHit(ServerLevel pLevel, LightningBolt pLightning) {
    }

    public void refreshDimensions() {
    }

    public boolean canCollideWith(Entity entity) {
        return false;
    }

    public String getJoyType() {
        return (String)this.entityData.get(SIT_TYPE);
    }

    public void setJoyType(String type) {
        this.entityData.set(SIT_TYPE, (Object)type);
    }
}

