/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.passive;

import com.github.tartaricacid.touhoulittlemaid.api.mixin.INavigationMixin;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidPathNavigation;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.navigation.MaidUnderWaterPathNavigation;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathComputationType;
import org.jetbrains.annotations.Nullable;

public class MaidNavigationManager {
    private final MaidPathNavigation basicNavigation;
    private final AmphibiousPathNavigation waterNavigation;
    private final EntityMaid maid;
    private final Level level;
    private Mode mode = Mode.GROUND;

    public MaidNavigationManager(EntityMaid maid) {
        this.maid = maid;
        this.level = maid.level;
        this.basicNavigation = new MaidPathNavigation((Mob)maid, maid.level);
        this.waterNavigation = new MaidUnderWaterPathNavigation((Mob)maid, maid.level);
        maid.setNavigation((PathNavigation)this.basicNavigation);
    }

    public void tick() {
        if (!this.level.isClientSide && this.maid.isEffectiveAi()) {
            if (this.mode != Mode.WATER && this.maid.isInWater() && this.shouldStartOrStopSwim(5)) {
                if (this.switchToNavigation(Mode.WATER, (PathNavigation)this.waterNavigation)) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    this.maid.getSwimManager().setReadyToLand(false);
                }
            } else if (this.mode != Mode.WATER && this.maid.isUnderWater() && this.mayBeStuckUnderWater(this.maid.blockPosition())) {
                if (this.switchToNavigation(Mode.WATER, (PathNavigation)this.waterNavigation)) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    this.maid.getSwimManager().setReadyToLand(false);
                }
            } else if (this.mode != Mode.WATER && this.maid.isInWater() && this.targetingUnderWater()) {
                if (this.switchToNavigation(Mode.WATER, (PathNavigation)this.waterNavigation)) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    this.maid.getSwimManager().setReadyToLand(false);
                }
            } else if (this.mode == Mode.WATER) {
                boolean shouldUseWater = this.maid.isInWater() && this.targetingUnderWater() || this.maid.isUnderWater() && this.mayBeStuckUnderWater(this.maid.blockPosition());
                BlockPos endPos = this.getEndPos((PathNavigation)this.waterNavigation);
                if (!shouldUseWater && endPos != null) {
                    if (!this.shouldStartOrStopSwim(2)) {
                        if (!this.level.isWaterAt(endPos) && !this.level.isWaterAt(endPos.below())) {
                            if (this.switchToNavigation(Mode.GROUND, (PathNavigation)this.basicNavigation)) {
                                this.maid.getSwimManager().setReadyToLand(true);
                                this.maid.getSwimManager().setWantToSwim(false);
                            }
                        } else if (this.isWaterSurface(endPos)) {
                            this.maid.getSwimManager().setWantToSwim(false);
                            this.maid.getSwimManager().setReadyToLand(false);
                        } else {
                            this.maid.getSwimManager().setWantToSwim(true);
                            this.maid.getSwimManager().setReadyToLand(false);
                        }
                    } else if (!this.maid.isInWater()) {
                        if (this.switchToNavigation(Mode.GROUND, (PathNavigation)this.basicNavigation)) {
                            this.maid.getSwimManager().setWantToSwim(false);
                            this.maid.getSwimManager().setReadyToLand(false);
                        }
                    } else if (!this.maid.isUnderWater()) {
                        this.maid.getSwimManager().setWantToSwim(false);
                    } else {
                        this.maid.getSwimManager().setWantToSwim(true);
                        this.maid.getSwimManager().setSwimTarget(endPos);
                    }
                } else if (endPos == null && this.maid.getSwimManager().isGoingToBreath()) {
                    this.maid.getSwimManager().setWantToSwim(false);
                } else if (shouldUseWater) {
                    this.maid.getSwimManager().setWantToSwim(true);
                    if (endPos != null) {
                        this.maid.getSwimManager().setSwimTarget(endPos);
                    }
                }
            }
        }
        if (this.mode != Mode.WATER) {
            this.maid.getSwimManager().setWantToSwim(false);
        }
    }

    private boolean targetingUnderWater() {
        if (!this.maid.getBrain().hasMemoryValue(MemoryModuleType.WALK_TARGET)) {
            return false;
        }
        return this.isUnderWater(((WalkTarget)this.maid.getBrain().getMemory(MemoryModuleType.WALK_TARGET).get()).getTarget().currentBlockPosition());
    }

    private boolean switchToNavigation(Mode mode, PathNavigation navigation) {
        PathNavigation currentNavigation = this.maid.getNavigation();
        if (!currentNavigation.isDone()) {
            Path path = navigation.createPath(currentNavigation.getPath().getEndNode().asBlockPos(), 0);
            if (path != null && path.canReach() && navigation.moveTo(path, ((INavigationMixin)currentNavigation).touhouLittleMaid$GetSpeedModifier())) {
                path.advance();
                this.maid.setNavigation(navigation);
                this.mode = mode;
                currentNavigation.stop();
                return true;
            }
        } else {
            this.maid.setNavigation(navigation);
            navigation.stop();
            currentNavigation.stop();
            return true;
        }
        return false;
    }

    private boolean shouldStartOrStopSwim(int minimumDistance) {
        Path path = this.maid.getNavigation().getPath();
        if (path == null || path.isDone() || path.getNextNodeIndex() > path.getNodeCount() - minimumDistance) {
            return false;
        }
        int i = path.getNextNodeIndex();
        int c = 0;
        while (c < minimumDistance) {
            if (!this.level.isWaterAt(path.getNode(i).asBlockPos())) {
                return false;
            }
            ++c;
            ++i;
        }
        return true;
    }

    private boolean mayBeStuckUnderWater(BlockPos pos) {
        return this.level.isWaterAt(pos) && !this.level.getBlockState(pos.above()).isPathfindable(PathComputationType.LAND);
    }

    public PathNavigation getBasicNavigation() {
        return this.basicNavigation;
    }

    public PathNavigation getWaterNavigation() {
        return this.waterNavigation;
    }

    public boolean isWaterSurface(BlockPos pos) {
        return this.level.isWaterAt(pos) && this.level.getBlockState(pos.above()).isAir() || this.level.isWaterAt(pos.below()) && this.level.getBlockState(pos).isAir() || this.level.isWaterAt(pos.above()) && this.level.getBlockState(pos.above(2)).isAir();
    }

    private boolean isUnderWater(BlockPos blockPos) {
        return this.level.isWaterAt(blockPos) && this.level.isWaterAt(blockPos.above()) && this.level.isWaterAt(blockPos.above(2));
    }

    @Nullable
    public BlockPos getEndPos(PathNavigation navigation) {
        if (navigation.getPath() == null) {
            return null;
        }
        if (navigation.getPath().getEndNode() == null) {
            return null;
        }
        return navigation.getPath().getEndNode().asBlockPos();
    }

    public void resetNavigation() {
        this.maid.setNavigation((PathNavigation)this.basicNavigation);
        this.basicNavigation.stop();
        this.waterNavigation.stop();
        this.maid.getSwimManager().setWantToSwim(false);
        this.maid.getSwimManager().setReadyToLand(false);
        this.mode = Mode.GROUND;
    }

    public static enum Mode {
        GROUND,
        WATER;

    }
}

