/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.entity.task;

import com.github.tartaricacid.touhoulittlemaid.api.task.IMaidTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidSnowballTargetTask;
import com.github.tartaricacid.touhoulittlemaid.entity.ai.brain.task.MaidStartSnowballAttacking;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitSounds;
import com.github.tartaricacid.touhoulittlemaid.util.SoundUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;

public class TaskIdle
implements IMaidTask {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"touhou_little_maid", (String)"idle");

    @Override
    public ResourceLocation getUid() {
        return UID;
    }

    @Override
    public ItemStack getIcon() {
        return Items.FEATHER.getDefaultInstance();
    }

    @Override
    @Nullable
    public SoundEvent getAmbientSound(EntityMaid maid) {
        return SoundUtil.environmentSound(maid, (SoundEvent)InitSounds.MAID_IDLE.get(), 0.5f);
    }

    @Override
    public List<Pair<Integer, BehaviorControl<? super EntityMaid>>> createBrainTasks(EntityMaid maid) {
        Pair findSnowballTarget = Pair.of((Object)6, new MaidStartSnowballAttacking<EntityMaid>(this::canSnowballFight, this::findFirstValidSnowballTarget));
        Pair snowballFight = Pair.of((Object)7, (Object)((Object)new MaidSnowballTargetTask(50)));
        return Lists.newArrayList((Object[])new Pair[]{findSnowballTarget, snowballFight});
    }

    private boolean canSnowballFight(EntityMaid maid) {
        Level world = maid.level();
        BlockPos pos = maid.blockPosition();
        return !maid.isBegging() && ((Biome)world.getBiome(pos).value()).coldEnoughToSnow(pos) && world.getBlockState(pos).is(Blocks.SNOW);
    }

    private Optional<? extends LivingEntity> findFirstValidSnowballTarget(EntityMaid maid) {
        return maid.getBrain().getMemory(MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES).flatMap(list -> list.find(e -> this.isSnowballTarget((LivingEntity)e, maid)).filter(e -> maid.isWithinRestriction(e.blockPosition())).findFirst());
    }

    private boolean isSnowballTarget(LivingEntity entity, EntityMaid maid) {
        if (maid.isOwnedBy(entity)) {
            return true;
        }
        if (entity instanceof EntityMaid) {
            EntityMaid maidOther = (EntityMaid)entity;
            if (maid.getOwner() != null) {
                return maid.getOwner().equals((Object)maidOther.getOwner());
            }
        }
        return false;
    }
}

