/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.event.maid;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.event.InteractMaidEvent;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@EventBusSubscriber
public final class ApplyPotionEffectEvent {
    @SubscribeEvent
    public static void onInteractMaid(InteractMaidEvent event) {
        ItemStack stack = event.getStack();
        EntityMaid maid = event.getMaid();
        Level world = event.getWorld();
        Player player = event.getPlayer();
        if (player.isDiscrete() && stack.getItem() == Items.POTION) {
            stack.getItem().finishUsingItem(stack.copy(), world, (LivingEntity)maid);
            if (!player.isCreative()) {
                stack.shrink(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE));
            }
            maid.playSound(SoundEvents.GENERIC_DRINK, 0.6f, 0.8f + world.random.nextFloat() * 0.4f);
            event.setCanceled(true);
        }
        if (player.isDiscrete() && stack.getItem() == Items.MILK_BUCKET) {
            maid.removeEffectsCuredBy(EffectCures.MILK);
            if (!player.isCreative()) {
                stack.shrink(1);
                ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET));
            }
            maid.playSound(SoundEvents.GENERIC_DRINK, 0.6f, 0.8f + world.random.nextFloat() * 0.4f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "clear_maid_effects");
            }
            event.setCanceled(true);
        }
    }
}

