/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.render.built;

import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.Cube;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.FaceUv;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.ModelProperties;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.UvFaces;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.geo.raw.pojo.UvUnion;
import com.github.tartaricacid.touhoulittlemaid.geckolib3.util.VectorUtils;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class GeoMesh {
    public static final int FACE_COUNT = 6;
    private final int cubeCount;
    private final int[] faces;
    private final Vector3f[] position;
    private final Vector3f[] dx;
    private final Vector3f[] dy;
    private final Vector3f[] dz;
    private final float[] u0;
    private final float[] v0;
    private final float[] u1;
    private final float[] v1;

    public GeoMesh(int cubeCount, int[] faces, Vector3f[] position, Vector3f[] dx, Vector3f[] dy, Vector3f[] dz, float[] u0, float[] v0, float[] u1, float[] v1) {
        this.cubeCount = cubeCount;
        this.faces = faces;
        this.position = position;
        this.dx = dx;
        this.dy = dy;
        this.dz = dz;
        this.u0 = u0;
        this.v0 = v0;
        this.u1 = u1;
        this.v1 = v1;
    }

    public int faces(int index) {
        return this.faces[index];
    }

    public Vector3f position(int index) {
        return this.position[index];
    }

    public Vector3f dx(int index) {
        return this.dx[index];
    }

    public Vector3f dy(int index) {
        return this.dy[index];
    }

    public Vector3f dz(int index) {
        return this.dz[index];
    }

    public float u0(int index, int face) {
        return this.u0[index * 6 + face];
    }

    public float v0(int index, int face) {
        return this.v0[index * 6 + face];
    }

    public float u1(int index, int face) {
        return this.u1[index * 6 + face];
    }

    public float v1(int index, int face) {
        return this.v1[index * 6 + face];
    }

    public float downU0(int index) {
        return this.u0(index, 0);
    }

    public float downV0(int index) {
        return this.v0(index, 0);
    }

    public float downU1(int index) {
        return this.u1(index, 0);
    }

    public float downV1(int index) {
        return this.v1(index, 0);
    }

    public float upU0(int index) {
        return this.u0(index, 1);
    }

    public float upV0(int index) {
        return this.v0(index, 1);
    }

    public float upU1(int index) {
        return this.u1(index, 1);
    }

    public float upV1(int index) {
        return this.v1(index, 1);
    }

    public float northU0(int index) {
        return this.u0(index, 2);
    }

    public float northV0(int index) {
        return this.v0(index, 2);
    }

    public float northU1(int index) {
        return this.u1(index, 2);
    }

    public float northV1(int index) {
        return this.v1(index, 2);
    }

    public float southU0(int index) {
        return this.u0(index, 3);
    }

    public float southV0(int index) {
        return this.v0(index, 3);
    }

    public float southU1(int index) {
        return this.u1(index, 3);
    }

    public float southV1(int index) {
        return this.v1(index, 3);
    }

    public float westU0(int index) {
        return this.u0(index, 4);
    }

    public float westV0(int index) {
        return this.v0(index, 4);
    }

    public float westU1(int index) {
        return this.u1(index, 4);
    }

    public float westV1(int index) {
        return this.v1(index, 4);
    }

    public float eastU0(int index) {
        return this.u0(index, 5);
    }

    public float eastV0(int index) {
        return this.v0(index, 5);
    }

    public float eastU1(int index) {
        return this.u1(index, 5);
    }

    public float eastV1(int index) {
        return this.v1(index, 5);
    }

    public int getCubeCount() {
        return this.cubeCount;
    }

    public static class GeoMeshBuilder {
        private static final float DEGREES_TO_RADIANS = (float)Math.PI / 180;
        private final Matrix4f poseMatrix = new Matrix4f();
        private final int cubeCount;
        private final int[] FACES;
        private final Vector3f[] POSITION;
        private final Vector3f[] DX;
        private final Vector3f[] DY;
        private final Vector3f[] DZ;
        private final float[] U0;
        private final float[] V0;
        private final float[] U1;
        private final float[] V1;
        private int index = 0;

        public GeoMeshBuilder(int cubeCount) {
            this.cubeCount = cubeCount;
            this.FACES = new int[cubeCount];
            this.POSITION = new Vector3f[cubeCount];
            this.DX = new Vector3f[cubeCount];
            this.DY = new Vector3f[cubeCount];
            this.DZ = new Vector3f[cubeCount];
            this.U0 = new float[cubeCount * 6];
            this.V0 = new float[cubeCount * 6];
            this.U1 = new float[cubeCount * 6];
            this.V1 = new float[cubeCount * 6];
            for (int i = 0; i < cubeCount; ++i) {
                this.POSITION[i] = new Vector3f();
                this.DX[i] = new Vector3f();
                this.DY[i] = new Vector3f();
                this.DZ[i] = new Vector3f();
            }
        }

        public void addCube(Cube cubeIn, ModelProperties properties, Double boneInflate, Boolean mirror) {
            float textureHeight = properties.getTextureHeight().floatValue();
            float textureWidth = properties.getTextureWidth().floatValue();
            float inflate = cubeIn.getInflate() == null ? boneInflate.floatValue() : cubeIn.getInflate().floatValue();
            Vector3f size = VectorUtils.fromArray(cubeIn.getSize()).toVector3f().mul(0.0625f);
            Vector3f origin = VectorUtils.fromArray(cubeIn.getOrigin()).toVector3f().mul(0.0625f);
            float diff = Math.max(0.001f, size.x + (inflate /= 16.0f) * 2.0f);
            Vector3f P13 = new Vector3f(-(origin.x + size.x) - inflate, origin.y - inflate, origin.z - inflate);
            boolean finallyMirror = false;
            if (cubeIn.getMirror() != null) {
                finallyMirror = cubeIn.getMirror();
            } else if (mirror != null) {
                finallyMirror = mirror;
            }
            if (finallyMirror) {
                P13.x += diff;
                diff = -diff;
            }
            Vector3f rotation = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getRotation()));
            rotation.mul((float)(-Math.PI) / 180, (float)(-Math.PI) / 180, (float)Math.PI / 180);
            Vector3f pivot = VectorUtils.convertDoubleToFloat(VectorUtils.fromArray(cubeIn.getPivot()));
            pivot.mul(-0.0625f, 0.0625f, 0.0625f);
            this.poseMatrix.identity();
            Quaternionf quat = new Quaternionf().rotateZYX(rotation.z(), rotation.y(), rotation.x());
            this.poseMatrix.rotateAround((Quaternionfc)quat, pivot.x(), pivot.y(), pivot.z());
            P13.mulPosition((Matrix4fc)this.poseMatrix);
            this.POSITION[this.index].set((Vector3fc)P13);
            this.DX[this.index].set(this.poseMatrix.m00() * diff, this.poseMatrix.m01() * diff, this.poseMatrix.m02() * diff);
            diff = Math.max(0.001f, size.y + inflate * 2.0f);
            this.DY[this.index].set(this.poseMatrix.m10() * diff, this.poseMatrix.m11() * diff, this.poseMatrix.m12() * diff);
            diff = Math.max(0.001f, size.z + inflate * 2.0f);
            this.DZ[this.index].set(this.poseMatrix.m20() * diff, this.poseMatrix.m21() * diff, this.poseMatrix.m22() * diff);
            UvUnion uvUnion = cubeIn.getUv();
            boolean isBoxUV = uvUnion.isBoxUV;
            int faces = finallyMirror ? 64 : 0;
            int faceIndex = this.index * 6;
            if (!isBoxUV) {
                double[] uvSize;
                double[] uv;
                UvFaces faceUV = uvUnion.faceUV;
                FaceUv west = faceUV.getWest();
                FaceUv east = faceUV.getEast();
                FaceUv north = faceUV.getNorth();
                FaceUv south = faceUV.getSouth();
                FaceUv up = faceUV.getUp();
                FaceUv down = faceUV.getDown();
                if (down != null) {
                    faces |= 1;
                    uv = down.getUv();
                    uvSize = down.getUvSize();
                    this.U0[faceIndex] = (float)uv[0] / textureWidth;
                    this.V0[faceIndex] = (float)uv[1] / textureHeight;
                    this.U1[faceIndex] = ((float)uv[0] + (float)uvSize[0]) / textureWidth;
                    this.V1[faceIndex] = ((float)uv[1] + (float)uvSize[1]) / textureHeight;
                }
                if (up != null) {
                    faces |= 2;
                    uv = up.getUv();
                    uvSize = up.getUvSize();
                    this.U0[faceIndex + 1] = (float)uv[0] / textureWidth;
                    this.V0[faceIndex + 1] = (float)uv[1] / textureHeight;
                    this.U1[faceIndex + 1] = ((float)uv[0] + (float)uvSize[0]) / textureWidth;
                    this.V1[faceIndex + 1] = ((float)uv[1] + (float)uvSize[1]) / textureHeight;
                }
                if (north != null) {
                    faces |= 4;
                    uv = north.getUv();
                    uvSize = north.getUvSize();
                    this.U0[faceIndex + 2] = (float)uv[0] / textureWidth;
                    this.V0[faceIndex + 2] = (float)uv[1] / textureHeight;
                    this.U1[faceIndex + 2] = ((float)uv[0] + (float)uvSize[0]) / textureWidth;
                    this.V1[faceIndex + 2] = ((float)uv[1] + (float)uvSize[1]) / textureHeight;
                }
                if (south != null) {
                    faces |= 8;
                    uv = south.getUv();
                    uvSize = south.getUvSize();
                    this.U0[faceIndex + 3] = (float)uv[0] / textureWidth;
                    this.V0[faceIndex + 3] = (float)uv[1] / textureHeight;
                    this.U1[faceIndex + 3] = ((float)uv[0] + (float)uvSize[0]) / textureWidth;
                    this.V1[faceIndex + 3] = ((float)uv[1] + (float)uvSize[1]) / textureHeight;
                }
                if (west != null) {
                    faces |= 0x10;
                    uv = west.getUv();
                    uvSize = west.getUvSize();
                    this.U0[faceIndex + 4] = (float)uv[0] / textureWidth;
                    this.V0[faceIndex + 4] = (float)uv[1] / textureHeight;
                    this.U1[faceIndex + 4] = ((float)uv[0] + (float)uvSize[0]) / textureWidth;
                    this.V1[faceIndex + 4] = ((float)uv[1] + (float)uvSize[1]) / textureHeight;
                }
                if (east != null) {
                    faces |= 0x20;
                    uv = east.getUv();
                    uvSize = east.getUvSize();
                    this.U0[faceIndex + 5] = (float)uv[0] / textureWidth;
                    this.V0[faceIndex + 5] = (float)uv[1] / textureHeight;
                    this.U1[faceIndex + 5] = ((float)uv[0] + (float)uvSize[0]) / textureWidth;
                    this.V1[faceIndex + 5] = ((float)uv[1] + (float)uvSize[1]) / textureHeight;
                }
            } else {
                faces |= 0x3F;
                double[] uv = cubeIn.getUv().boxUVCoords;
                Vec3 uvSize = VectorUtils.fromArray(cubeIn.getSize());
                uvSize = new Vec3(Math.floor(uvSize.x), Math.floor(uvSize.y), Math.floor(uvSize.z));
                float u0 = (float)(uv[0] + uvSize.z + uvSize.x);
                float v0 = (float)(uv[1] + uvSize.z);
                this.U0[faceIndex] = u0 / textureWidth;
                this.V0[faceIndex] = v0 / textureHeight;
                this.U1[faceIndex] = (u0 + (float)uvSize.x) / textureWidth;
                this.V1[faceIndex] = (v0 - (float)uvSize.z) / textureHeight;
                u0 = (float)(uv[0] + uvSize.z);
                v0 = (float)uv[1];
                this.U0[faceIndex + 1] = u0 / textureWidth;
                this.V0[faceIndex + 1] = v0 / textureHeight;
                this.U1[faceIndex + 1] = (u0 + (float)uvSize.x) / textureWidth;
                this.V1[faceIndex + 1] = (v0 + (float)uvSize.z) / textureHeight;
                u0 = (float)(uv[0] + uvSize.z);
                v0 = (float)(uv[1] + uvSize.z);
                this.U0[faceIndex + 2] = u0 / textureWidth;
                this.V0[faceIndex + 2] = v0 / textureHeight;
                this.U1[faceIndex + 2] = (u0 + (float)uvSize.x) / textureWidth;
                this.V1[faceIndex + 2] = (v0 + (float)uvSize.y) / textureHeight;
                u0 = (float)(uv[0] + uvSize.z + uvSize.x + uvSize.z);
                v0 = (float)(uv[1] + uvSize.z);
                this.U0[faceIndex + 3] = u0 / textureWidth;
                this.V0[faceIndex + 3] = v0 / textureHeight;
                this.U1[faceIndex + 3] = (u0 + (float)uvSize.x) / textureWidth;
                this.V1[faceIndex + 3] = (v0 + (float)uvSize.y) / textureHeight;
                u0 = (float)(uv[0] + uvSize.z + uvSize.x);
                v0 = (float)(uv[1] + uvSize.z);
                this.U0[faceIndex + 4] = u0 / textureWidth;
                this.V0[faceIndex + 4] = v0 / textureHeight;
                this.U1[faceIndex + 4] = (u0 + (float)uvSize.z) / textureWidth;
                this.V1[faceIndex + 4] = (v0 + (float)uvSize.y) / textureHeight;
                u0 = (float)uv[0];
                v0 = (float)(uv[1] + uvSize.z);
                this.U0[faceIndex + 5] = u0 / textureWidth;
                this.V0[faceIndex + 5] = v0 / textureHeight;
                this.U1[faceIndex + 5] = (u0 + (float)uvSize.z) / textureWidth;
                this.V1[faceIndex + 5] = (v0 + (float)uvSize.y) / textureHeight;
            }
            this.FACES[this.index] = faces;
            ++this.index;
        }

        public GeoMesh build() {
            return new GeoMesh(this.cubeCount, this.FACES, this.POSITION, this.DX, this.DY, this.DZ, this.U0, this.V0, this.U1, this.V1);
        }
    }
}

