/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.inventory.container.config;

import com.github.tartaricacid.touhoulittlemaid.ai.manager.site.ClientAvailableSitesSync;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.inventory.container.AbstractMaidContainer;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class MaidAIChatConfigContainer
extends AbstractMaidContainer {
    public static final MenuType<MaidAIChatConfigContainer> TYPE = IMenuTypeExtension.create(MaidAIChatConfigContainer::create);
    private static final int PLAYER_INVENTORY_SIZE = 27;
    private final CompoundTag configData;
    private final Map<String, Map<String, String>> llmSites;
    private final Map<String, Map<String, String>> ttsSites;

    public MaidAIChatConfigContainer(int id, Inventory inventory, int entityId, @Nullable CompoundTag configData, Map<String, Map<String, String>> llmSites, Map<String, Map<String, String>> ttsSites) {
        super(TYPE, id, inventory, entityId);
        this.configData = configData;
        this.llmSites = llmSites;
        this.ttsSites = ttsSites;
    }

    public static MenuProvider create(final EntityMaid maid) {
        return new MenuProvider(){

            public Component getDisplayName() {
                return Component.literal((String)"Maid AI Chat Config Container");
            }

            public AbstractContainerMenu createMenu(int index, Inventory playerInventory, Player player) {
                int entityId = maid.getId();
                CompoundTag configData = maid.getAiChatManager().writeToTag(new CompoundTag());
                return new MaidAIChatConfigContainer(index, playerInventory, entityId, configData, ClientAvailableSitesSync.getClientLLMSites(), ClientAvailableSitesSync.getClientTTSSites());
            }

            public boolean shouldTriggerClientSideContainerClosingOnOpen() {
                return false;
            }
        };
    }

    @NotNull
    private static MaidAIChatConfigContainer create(int windowId, Inventory inv, FriendlyByteBuf data) {
        int entityId = data.readInt();
        CompoundTag configData = data.readNbt();
        Pair<Map<String, Map<String, String>>, Map<String, Map<String, String>>> sites = ClientAvailableSitesSync.readFromNetwork(data);
        return new MaidAIChatConfigContainer(windowId, inv, entityId, configData, (Map)sites.getLeft(), (Map)sites.getRight());
    }

    public CompoundTag getConfigData() {
        return this.configData;
    }

    public Map<String, Map<String, String>> getLLMSites() {
        return this.llmSites;
    }

    public Map<String, Map<String, String>> getTTSSites() {
        return this.ttsSites;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack stack1 = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack stack2 = slot.getItem();
            stack1 = stack2.copy();
            if (index < 27 ? !this.moveItemStackTo(stack2, 27, this.slots.size(), false) : !this.moveItemStackTo(stack2, 0, 27, true)) {
                return ItemStack.EMPTY;
            }
            if (stack2.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return stack1;
    }
}

