/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.block.BlockStatue;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityStatue;
import com.google.common.collect.Lists;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ItemChisel
extends Item {
    public ItemChisel() {
        super(new Item.Properties().stacksTo(1).durability(64));
    }

    public InteractionResult useOn(UseOnContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        if (context.getHand() == InteractionHand.MAIN_HAND && player != null) {
            if (worldIn.getBlockState(pos).getBlock() != Blocks.CLAY) {
                if (!worldIn.isClientSide) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.chisel.hit_block_error"));
                }
                return InteractionResult.PASS;
            }
            if (player.getOffhandItem().getItem() != InitItems.PHOTO.get()) {
                if (!worldIn.isClientSide) {
                    player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.chisel.offhand_not_photo"));
                }
                return InteractionResult.PASS;
            }
            this.genStatueBlocks(player, worldIn, pos, context.getClickedFace());
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "chisel_statue");
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    private void genStatueBlocks(@Nonnull Player player, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Direction facing) {
        CustomData compoundData = (CustomData)player.getOffhandItem().get(InitDataComponent.MAID_INFO);
        if (compoundData != null) {
            TileEntityStatue.Size[] sizes = TileEntityStatue.Size.values();
            for (int i = sizes.length - 1; i >= 0; --i) {
                TileEntityStatue.Size size = sizes[i];
                Vec3i dimension = size.getDimension();
                Object[] posList = this.checkBlocks(worldIn, pos, dimension, facing);
                if (posList == null) continue;
                boolean isTiny = posList.length == 1;
                for (BlockPos blockPos : posList) {
                    worldIn.setBlock(blockPos, (BlockState)((Block)InitBlocks.STATUE.get()).defaultBlockState().setValue((Property)BlockStatue.IS_TINY, (Comparable)Boolean.valueOf(isTiny)), 3);
                    BlockEntity te = worldIn.getBlockEntity(blockPos);
                    if (!(te instanceof TileEntityStatue)) continue;
                    TileEntityStatue statue = (TileEntityStatue)te;
                    if (blockPos.equals((Object)pos)) {
                        statue.setForgeData(size, true, pos, facing, Lists.newArrayList((Object[])posList), compoundData.copyTag());
                        continue;
                    }
                    statue.setForgeData(size, false, pos, facing, Lists.newArrayList((Object[])posList), null);
                }
                player.getMainHandItem().hurtAndBreak(size.ordinal() + 1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                player.playSound(SoundEvents.ANVIL_LAND, 0.5f, 1.5f);
                return;
            }
        }
    }

    @Nullable
    private BlockPos[] checkBlocks(@Nonnull Level worldIn, BlockPos origin, Vec3i dimension, Direction facing) {
        BlockPos[] posList = new BlockPos[dimension.getX() * dimension.getY() * dimension.getZ()];
        int index = 0;
        for (int x = 0; x < dimension.getX(); ++x) {
            for (int y = 0; y < dimension.getY(); ++y) {
                for (int z = 0; z < dimension.getZ(); ++z) {
                    BlockPos pos;
                    posList[index] = pos = (switch (facing) {
                        case Direction.WEST -> origin.offset(new Vec3i(x, y, z));
                        case Direction.SOUTH -> origin.offset(new Vec3i(x, y, -z));
                        default -> origin.offset(new Vec3i(-x, y, z));
                        case Direction.EAST -> origin.offset(new Vec3i(-x, y, -z));
                    });
                    ++index;
                    if (worldIn.getBlockState(pos).getBlock() == Blocks.CLAY) continue;
                    return null;
                }
            }
        }
        return posList;
    }
}

