/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ItemMaidBed
extends BlockItem {
    private static final String COLOR_TAG = "BedColor";

    public ItemMaidBed() {
        super((Block)InitBlocks.MAID_BED.get(), new Item.Properties().stacksTo(1));
    }

    public static void setColor(DyeColor color, ItemStack bed) {
        bed.set(InitDataComponent.BED_COLOR_TAG, (Object)color);
    }

    public static DyeColor getColor(ItemStack bed) {
        return (DyeColor)bed.getOrDefault(InitDataComponent.BED_COLOR_TAG, (Object)DyeColor.PINK);
    }

    protected boolean placeBlock(BlockPlaceContext context, BlockState state) {
        return context.getLevel().setBlock(context.getClickedPos(), state, 26);
    }

    public void appendHoverText(ItemStack pStack, @Nullable Item.TooltipContext context, List<Component> pTooltip, TooltipFlag pFlag) {
        DyeColor color = ItemMaidBed.getColor(pStack);
        MutableComponent colorText = Component.translatable((String)("color.minecraft." + color.getName()));
        MutableComponent all = Component.translatable((String)"item.color", (Object[])new Object[]{colorText}).withStyle(ChatFormatting.GRAY);
        pTooltip.add((Component)all);
    }
}

