/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.client.gui.item.ServantBellSetScreen;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataComponent;
import com.github.tartaricacid.touhoulittlemaid.init.InitItems;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.item.ItemFoxScroll;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;

public class ItemServantBell
extends Item {
    private static final int MIN_USE_DURATION = 20;

    public ItemServantBell() {
        super(new Item.Properties().stacksTo(1));
    }

    public static void recordMaidInfo(ItemStack stack, UUID uuid, String tip) {
        if (stack.is((Item)InitItems.SERVANT_BELL.get())) {
            stack.set(InitDataComponent.SAKUYA_BELL_UUID_TAG, (Object)uuid);
            stack.set(InitDataComponent.SAKUYA_BELL_TIP_TAG, (Object)tip);
        }
    }

    @Nullable
    public static ItemFoxScroll.TrackInfo getMaidShow(ItemStack stack) {
        return (ItemFoxScroll.TrackInfo)stack.get(InitDataComponent.SAKUYA_BELL_SHOW_TAG);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand usedHand) {
        EntityMaid maid;
        if (usedHand == InteractionHand.MAIN_HAND && target instanceof EntityMaid && (maid = (EntityMaid)target).isOwnedBy((LivingEntity)player)) {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                this.openServantBellSetScreen(maid);
            }
            return InteractionResult.SUCCESS;
        }
        return super.interactLivingEntity(stack, player, target, usedHand);
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        UUID searchUuid = this.getMaidUuid(stack);
        if (searchUuid != null) {
            playerIn.startUsingItem(handIn);
            return InteractionResultHolder.consume((Object)stack);
        }
        if (!worldIn.isClientSide) {
            playerIn.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.servant_bell.data_is_empty"));
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        Player player;
        block9: {
            block8: {
                if (!(entityLiving instanceof Player)) break block8;
                player = (Player)entityLiving;
                if (timeLeft >= 20) break block9;
            }
            return;
        }
        UUID searchUuid = this.getMaidUuid(stack);
        if (searchUuid == null) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.servant_bell.data_is_empty"));
            return;
        }
        if (worldIn instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)worldIn;
            List maids = serverLevel.getEntities(EntityMaid.TYPE, maid -> this.checkMaidUuid(player, (EntityMaid)maid, searchUuid));
            if (maids.isEmpty()) {
                this.showMaidInfo(worldIn, player, stack, searchUuid);
            } else {
                stack.remove(InitDataComponent.SAKUYA_BELL_SHOW_TAG);
                this.teleportMaid(player, maids);
            }
        }
        worldIn.playSound(null, player.blockPosition(), SoundEvents.BELL_BLOCK, SoundSource.BLOCKS, 2.0f, 1.0f);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "use_servant_bell");
        }
        player.getCooldowns().addCooldown((Item)this, 20);
    }

    @Nullable
    private UUID getMaidUuid(ItemStack stack) {
        return (UUID)stack.get(InitDataComponent.SAKUYA_BELL_UUID_TAG);
    }

    private void teleportMaid(Player player, List<? extends EntityMaid> maids) {
        maids.forEach(maid -> {
            maid.setHomeModeEnable(false);
            maid.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 1, true, false));
            maid.teleportTo(player.getX() + (double)player.getRandom().nextInt(3) - 1.0, player.getY(), player.getZ() + (double)player.getRandom().nextInt(3) - 1.0);
        });
    }

    private void showMaidInfo(Level worldIn, Player player, ItemStack stack, UUID searchUuid) {
        MaidWorldData data = MaidWorldData.get(worldIn);
        if (data == null) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.servant_bell.no_result"));
            return;
        }
        List<MaidInfo> infos = data.getPlayerMaidInfos(player);
        if (infos == null || infos.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.servant_bell.no_result"));
            return;
        }
        infos.stream().filter(info -> info.getEntityId().equals(searchUuid)).findFirst().ifPresentOrElse(info -> {
            String dimension = info.getDimension();
            String playerDimension = player.level.dimension().location().toString();
            stack.set(InitDataComponent.SAKUYA_BELL_SHOW_TAG, (Object)new ItemFoxScroll.TrackInfo(dimension, info.getChunkPos()));
            if (dimension.equals(playerDimension)) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.servant_bell.show_pos"));
            } else {
                player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.servant_bell.not_same_dimension", (Object[])new Object[]{dimension}));
            }
        }, () -> player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.servant_bell.no_result")));
    }

    private boolean checkMaidUuid(Player player, EntityMaid maid, UUID searchUuid) {
        return maid.isOwnedBy((LivingEntity)player) && maid.getUUID().equals(searchUuid);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void openServantBellSetScreen(EntityMaid maid) {
        if (maid.level.isClientSide) {
            Minecraft.getInstance().setScreen((Screen)new ServantBellSetScreen(maid));
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity livingEntity) {
        return 100;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    public Component getName(ItemStack stack) {
        String tip = (String)stack.get(InitDataComponent.SAKUYA_BELL_TIP_TAG);
        if (tip != null) {
            return Component.literal((String)tip).withStyle(ChatFormatting.GOLD).withStyle(ChatFormatting.UNDERLINE);
        }
        return super.getName(stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flagIn) {
        UUID uuid = this.getMaidUuid(stack);
        if (uuid != null) {
            tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.servant_bell.uuid", (Object[])new Object[]{uuid.toString()}).withStyle(ChatFormatting.GRAY));
            tooltip.add((Component)CommonComponents.space());
        }
        tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.servant_bell.desc.1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.servant_bell.desc.2").withStyle(ChatFormatting.GRAY));
    }
}

