/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidInfo;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemTrumpet
extends Item {
    private static final int MIN_USE_DURATION = 20;

    public ItemTrumpet() {
        super(new Item.Properties().stacksTo(1));
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (timeLeft >= 20) {
                if (worldIn instanceof ServerLevel) {
                    List<MaidInfo> infos;
                    ((ServerLevel)worldIn).getEntities(EntityMaid.TYPE, Entity::isAlive).stream().filter(maid -> maid.isOwnedBy((LivingEntity)player)).forEach(maid -> this.teleportToOwner((EntityMaid)maid, player));
                    MaidWorldData data = MaidWorldData.get(worldIn);
                    if (data != null && (infos = data.getPlayerMaidInfos(player)) != null && !infos.isEmpty()) {
                        player.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.trumpet.unloaded_maid", (Object[])new Object[]{infos.size()}).withStyle(ChatFormatting.DARK_RED));
                    }
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "use_trumpet");
                }
                player.getCooldowns().addCooldown((Item)this, 200);
            }
        }
    }

    private void teleportToOwner(EntityMaid maid, Player player) {
        maid.setHomeModeEnable(false);
        maid.teleportTo(player.getX() + (double)player.getRandom().nextInt(3) - 1.0, player.getY(), player.getZ() + (double)player.getRandom().nextInt(3) - 1.0);
    }

    public int getUseDuration(ItemStack stack, LivingEntity pEntity) {
        return 100;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.trumpet.desc.usage").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltips.touhou_little_maid.trumpet.desc.note").withStyle(ChatFormatting.DARK_RED));
    }
}

