/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.item.bauble;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.api.bauble.IMaidBauble;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class UndyingTotemBauble
implements IMaidBauble {
    @Override
    public boolean onDeath(EntityMaid maid, ItemStack baubleItem, DamageSource source) {
        if (!source.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            baubleItem.shrink(1);
            maid.setHealth(1.0f);
            maid.removeAllEffects();
            maid.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 900, 1));
            maid.addEffect(new MobEffectInstance(MobEffects.ABSORPTION, 100, 1));
            maid.addEffect(new MobEffectInstance(MobEffects.FIRE_RESISTANCE, 800, 0));
            maid.level.broadcastEntityEvent((Entity)maid, (byte)35);
            LivingEntity livingEntity = maid.getOwner();
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                ((MaidEventTrigger)((Object)InitTrigger.MAID_EVENT.get())).trigger(serverPlayer, "use_undead_bauble");
            }
            return true;
        }
        return false;
    }
}

