/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.loot;

import com.github.tartaricacid.touhoulittlemaid.init.InitLootModifier;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record LootTableTypeCondition(ResourceLocation lootTableType, @Nullable ResourceKey<LootTable> lootTableId, ResourceKey<LootTable> lootTableAdd) implements LootItemCondition
{
    public static final MapCodec<LootTableTypeCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("loot_table_type").forGetter(m -> m.lootTableType), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).optionalFieldOf("loot_table_id").forGetter(m -> Optional.ofNullable(m.lootTableId)), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table_add").forGetter(m -> m.lootTableAdd)).apply((Applicative)instance, (type, id, add) -> new LootTableTypeCondition((ResourceLocation)type, (ResourceKey<LootTable>)((ResourceKey)id.orElse(null)), (ResourceKey<LootTable>)add)));

    public boolean test(LootContext context) {
        ResourceLocation currentLootTable = context.getQueriedLootTableId();
        return !currentLootTable.equals((Object)this.lootTableAdd.location()) && this.typeAreEquals(context) && this.idAreEquals(context);
    }

    private boolean typeAreEquals(LootContext context) {
        ResourceKey currentLootTable = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)context.getQueriedLootTableId());
        return context.getResolver().get(Registries.LOOT_TABLE, currentLootTable).map(lootTable -> Objects.equals(((LootTable)lootTable.value()).getParamSet(), LootContextParamSets.REGISTRY.get((Object)this.lootTableType))).orElse(false);
    }

    private boolean idAreEquals(LootContext context) {
        if (this.lootTableId == null) {
            return true;
        }
        return context.getQueriedLootTableId().equals((Object)this.lootTableId.location());
    }

    public LootItemConditionType getType() {
        return InitLootModifier.LOOT_TABLE_TYPE.get();
    }
}

