/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.mixin;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.world.data.MaidWorldData;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.List;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.entity.Visibility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PersistentEntitySectionManager.class})
public abstract class PersistentEntitySectionManagerMixin {
    @Final
    @Shadow
    private LongSet chunksToUnload;
    @Final
    @Shadow
    private Long2ObjectMap<Visibility> chunkVisibility;
    @Final
    @Shadow
    EntitySectionStorage<EntityAccess> sectionStorage;

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/entity/PersistentEntitySectionManager;processUnloads()V")}, method={"tick"})
    private void companionTick(CallbackInfo ci) {
        this.chunksToUnload.forEach(l -> {
            if (this.chunkVisibility.get(l) != Visibility.HIDDEN || !this.areEntitiesLoaded(l)) {
                return;
            }
            List<EntityAccess> entities = this.sectionStorage.getExistingSectionsInChunk(l).flatMap(EntitySection::getEntities).toList();
            PersistentEntitySectionManagerMixin.handleChunkPreUnload(entities);
        });
    }

    @Unique
    private static void handleChunkPreUnload(List<EntityAccess> entities) {
        for (EntityAccess entityAccess : entities) {
            MaidWorldData data;
            Player owner;
            EntityMaid maid;
            LivingEntity livingEntity;
            if (!(entityAccess instanceof EntityMaid) || !((livingEntity = (maid = (EntityMaid)entityAccess).getOwner()) instanceof Player) || (owner = (Player)livingEntity).level() != maid.level() || !PersistentEntitySectionManagerMixin.shouldFollowOwner((LivingEntity)owner, maid) || !maid.teleportToOwner((LivingEntity)owner) || (data = MaidWorldData.get(maid.level)) == null) continue;
            data.removeInfo(maid);
        }
    }

    @Unique
    private static boolean shouldFollowOwner(LivingEntity owner, EntityMaid maid) {
        if (owner == null || owner.isDeadOrDying() || owner.isSpectator()) {
            return false;
        }
        return !maid.isHomeModeEnable() && maid.canBrainMoving();
    }

    @Shadow
    public abstract boolean areEntitiesLoaded(long var1);
}

