/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.ChairConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityChair;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record ChairModelPackage(int id, ResourceLocation modelId, float mountedHeight, boolean tameableCanRide, boolean noGravity) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ChairModelPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("chair_model"));
    public static final StreamCodec<ByteBuf, ChairModelPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ChairModelPackage::id, (StreamCodec)ResourceLocation.STREAM_CODEC, ChairModelPackage::modelId, (StreamCodec)ByteBufCodecs.FLOAT, ChairModelPackage::mountedHeight, (StreamCodec)ByteBufCodecs.BOOL, ChairModelPackage::tameableCanRide, (StreamCodec)ByteBufCodecs.BOOL, ChairModelPackage::noGravity, ChairModelPackage::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(ChairModelPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                boolean canChangeModel;
                ServerPlayer sender = (ServerPlayer)context.player();
                Entity entity = sender.level.getEntity(message.id);
                boolean bl = canChangeModel = (Boolean)ChairConfig.CHAIR_CHANGE_MODEL.get() != false || sender.isCreative();
                if (entity instanceof EntityChair) {
                    if (canChangeModel) {
                        EntityChair chair = (EntityChair)entity;
                        chair.setModelId(message.modelId.toString());
                        chair.setMountedHeight(message.mountedHeight);
                        chair.setTameableCanRide(message.tameableCanRide);
                        chair.setNoGravity(message.noGravity);
                        if (!message.tameableCanRide && !chair.getPassengers().isEmpty()) {
                            chair.ejectPassengers();
                        }
                        ((MaidEventTrigger)((Object)((Object)InitTrigger.MAID_EVENT.get()))).trigger(sender, "change_chair_model");
                    } else if (sender.isAlive()) {
                        sender.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.change_model.disabled"));
                    }
                }
            });
        }
    }
}

