/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public record ClearMaidAIDataPacket(int entityId, int msgIndex) implements CustomPacketPayload
{
    private static final int ALL_MSG_INDEX = -1;
    public static final CustomPacketPayload.Type<ClearMaidAIDataPacket> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("clear_maid_ai_data"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClearMaidAIDataPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, ClearMaidAIDataPacket::entityId, (StreamCodec)ByteBufCodecs.VAR_INT, ClearMaidAIDataPacket::msgIndex, ClearMaidAIDataPacket::new);

    public ClearMaidAIDataPacket(int entityId) {
        this(entityId, -1);
    }

    public static void handle(ClearMaidAIDataPacket message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> ClearMaidAIDataPacket.handle(message, (ServerPlayer)context.player()));
        }
    }

    private static void handle(ClearMaidAIDataPacket message, @Nullable ServerPlayer player) {
        EntityMaid maid;
        if (player == null) {
            return;
        }
        Entity entity = player.level.getEntity(message.entityId);
        if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).isOwnedBy((LivingEntity)player) && message.msgIndex == -1) {
            maid.getAiChatManager().getHistory().getDeque().clear();
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

