/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record OpenPlayerInventoryPackage(int action) implements CustomPacketPayload
{
    public static final int OPEN_PLAYER_INVENTORY = 0;
    public static final CustomPacketPayload.Type<OpenPlayerInventoryPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("open_player_inventory"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenPlayerInventoryPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, OpenPlayerInventoryPackage::action, OpenPlayerInventoryPackage::new);

    public static void handle(OpenPlayerInventoryPackage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> OpenPlayerInventoryPackage.onHandle(message));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(OpenPlayerInventoryPackage message) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (message.action == 0) {
            Minecraft.getInstance().setScreen((Screen)new InventoryScreen((Player)player));
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

