/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.network.message.SendEffectPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RequestEffectPackage(int id) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestEffectPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("request_effect"));
    public static final StreamCodec<ByteBuf, RequestEffectPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, RequestEffectPackage::id, RequestEffectPackage::new);

    public static void handle(RequestEffectPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = (ServerPlayer)context.player();
                Entity entity = sender.level.getEntity(message.id);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).isOwnedBy((LivingEntity)sender)) {
                    SendEffectPackage sendEffectMessage = new SendEffectPackage(message.id, maid.getActiveEffects());
                    PacketDistributor.sendToPlayer((ServerPlayer)sender, (CustomPacketPayload)sendEffectMessage, (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

