/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record SendEffectPackage(int id, Collection<MobEffectInstance> effects) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SendEffectPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("send_effect"));
    public static final StreamCodec<RegistryFriendlyByteBuf, Collection<MobEffectInstance>> COLLECTION_STREAM_CODEC = ByteBufCodecs.collection(ArrayList::new, (StreamCodec)MobEffectInstance.STREAM_CODEC, (int)256);
    public static final StreamCodec<RegistryFriendlyByteBuf, SendEffectPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, SendEffectPackage::id, COLLECTION_STREAM_CODEC, SendEffectPackage::effects, SendEffectPackage::new);

    public static void handle(SendEffectPackage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> SendEffectPackage.handle(message));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handle(SendEffectPackage message) {
        EntityMaid maid;
        Minecraft mc = Minecraft.getInstance();
        if (mc.level == null) {
            return;
        }
        Entity entity = mc.level.getEntity(message.id);
        if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).isAlive()) {
            maid.setEffects(message.effects.stream().map(EffectData::new).toList());
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public record EffectData(String descriptionId, int amplifier, int duration, int category) {
        public EffectData(MobEffectInstance effect) {
            this(effect.getDescriptionId(), effect.getAmplifier(), effect.getDuration(), ((MobEffect)effect.getEffect().value()).getCategory().ordinal());
        }
    }
}

