/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.data.MaidNumAttachment;
import com.github.tartaricacid.touhoulittlemaid.data.PowerAttachment;
import com.github.tartaricacid.touhoulittlemaid.init.InitDataAttachment;
import com.github.tartaricacid.touhoulittlemaid.network.message.SyncDataPackage;
import com.github.tartaricacid.touhoulittlemaid.tileentity.TileEntityMaidBeacon;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record StorageAndTakePowerPackage(BlockPos pos, float powerNum, boolean isStorage) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<StorageAndTakePowerPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("save_and_take_power"));
    public static final StreamCodec<ByteBuf, StorageAndTakePowerPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, StorageAndTakePowerPackage::pos, (StreamCodec)ByteBufCodecs.FLOAT, StorageAndTakePowerPackage::powerNum, (StreamCodec)ByteBufCodecs.BOOL, StorageAndTakePowerPackage::isStorage, StorageAndTakePowerPackage::new);

    public static void handle(StorageAndTakePowerPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                BlockEntity te;
                ServerPlayer sender = (ServerPlayer)context.player();
                Level world = sender.level();
                if (world.isLoaded(message.pos) && (te = world.getBlockEntity(message.pos)) instanceof TileEntityMaidBeacon) {
                    TileEntityMaidBeacon beacon = (TileEntityMaidBeacon)te;
                    PowerAttachment power = (PowerAttachment)sender.getData(InitDataAttachment.POWER_NUM);
                    MaidNumAttachment maidNum = (MaidNumAttachment)sender.getData(InitDataAttachment.MAID_NUM);
                    if (message.isStorage) {
                        StorageAndTakePowerPackage.storageLogic(message.powerNum, power, beacon);
                    } else {
                        StorageAndTakePowerPackage.takeLogic(message.powerNum, power, beacon);
                    }
                    PacketDistributor.sendToPlayer((ServerPlayer)sender, (CustomPacketPayload)new SyncDataPackage(power.get(), maidNum.get()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            });
        }
    }

    private static void storageLogic(float powerNum, PowerAttachment playerPower, TileEntityMaidBeacon beacon) {
        boolean beaconNotFull;
        boolean playerPowerIsEnough = powerNum <= playerPower.get();
        boolean bl = beaconNotFull = powerNum + beacon.getStoragePower() <= beacon.getMaxStorage();
        if (playerPowerIsEnough) {
            if (beaconNotFull) {
                playerPower.min(powerNum);
                beacon.setStoragePower(beacon.getStoragePower() + powerNum);
            } else {
                playerPower.min(beacon.getMaxStorage() - beacon.getStoragePower());
                beacon.setStoragePower(beacon.getMaxStorage());
            }
        }
    }

    private static void takeLogic(float powerNum, PowerAttachment playerPower, TileEntityMaidBeacon beacon) {
        boolean playerNotFull;
        boolean beaconIsEnough = powerNum <= beacon.getStoragePower();
        boolean bl = playerNotFull = powerNum + playerPower.get() < 5.0f;
        if (beaconIsEnough) {
            if (playerNotFull) {
                beacon.setStoragePower(beacon.getStoragePower() - powerNum);
                playerPower.add(powerNum);
            } else {
                beacon.setStoragePower(beacon.getStoragePower() - 5.0f + playerPower.get());
                playerPower.set(5.0f);
            }
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

