/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Position;
import com.github.tartaricacid.touhoulittlemaid.api.game.chess.Search;
import com.github.tartaricacid.touhoulittlemaid.network.message.WChessToServerPackage;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import com.github.tartaricacid.touhoulittlemaid.util.WChessUtil;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record WChessToClientPackage(BlockPos pos, String fenData) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<WChessToClientPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("wchess_to_client"));
    public static final StreamCodec<ByteBuf, WChessToClientPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, WChessToClientPackage::pos, (StreamCodec)ByteBufCodecs.STRING_UTF8, WChessToClientPackage::fenData, WChessToClientPackage::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(WChessToClientPackage message, IPayloadContext context) {
        if (context.flow().isClientbound()) {
            context.enqueueWork(() -> CompletableFuture.runAsync(() -> WChessToClientPackage.onHandle(message), Util.backgroundExecutor()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onHandle(WChessToClientPackage message) {
        int levelTime = 1000;
        long timeStart = System.currentTimeMillis();
        int move = 0;
        Position position = new Position();
        position.fromFen(message.fenData);
        boolean maidLost = WChessUtil.isMaid(position) && position.isMate();
        boolean playerLost = false;
        if (!maidLost) {
            move = new Search(position, 12).searchMain(levelTime);
            playerLost = position.makeMove(move) && WChessUtil.isPlayer(position) && position.isMate();
        }
        long timeRemain = Math.max(0, levelTime - (int)(System.currentTimeMillis() - timeStart));
        try {
            if (timeRemain > 0L) {
                Thread.sleep(timeRemain);
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        int moveFinal = move;
        boolean playerLostFinal = playerLost;
        Minecraft.getInstance().submitAsync(() -> PacketDistributor.sendToServer((CustomPacketPayload)new WChessToServerPackage(message.pos, moveFinal, maidLost, playerLostFinal), (CustomPacketPayload[])new CustomPacketPayload[0]));
    }
}

