/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.network.message;

import com.github.tartaricacid.touhoulittlemaid.advancements.maid.MaidEventTrigger;
import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MaidConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitTrigger;
import com.github.tartaricacid.touhoulittlemaid.util.ResourceLocationUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record YsmMaidModelPackage(int maidId, String modeId, String texture, Component name) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<YsmMaidModelPackage> TYPE = new CustomPacketPayload.Type(ResourceLocationUtil.getResourceLocation("ysm_maid_model"));
    public static final StreamCodec<RegistryFriendlyByteBuf, YsmMaidModelPackage> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.VAR_INT, YsmMaidModelPackage::maidId, (StreamCodec)ByteBufCodecs.STRING_UTF8, YsmMaidModelPackage::modeId, (StreamCodec)ByteBufCodecs.STRING_UTF8, YsmMaidModelPackage::texture, (StreamCodec)ComponentSerialization.STREAM_CODEC, YsmMaidModelPackage::name, YsmMaidModelPackage::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(YsmMaidModelPackage message, IPayloadContext context) {
        if (context.flow().isServerbound()) {
            context.enqueueWork(() -> {
                EntityMaid maid;
                ServerPlayer sender = (ServerPlayer)context.player();
                Entity entity = sender.level.getEntity(message.maidId);
                if (entity instanceof EntityMaid && (maid = (EntityMaid)entity).isOwnedBy((LivingEntity)sender)) {
                    if (sender.isCreative() || ((Boolean)MaidConfig.MAID_CHANGE_MODEL.get()).booleanValue()) {
                        maid.setIsYsmModel(true);
                        maid.setYsmModel(message.modeId, message.texture, message.name);
                        ((MaidEventTrigger)((Object)((Object)InitTrigger.MAID_EVENT.get()))).trigger(sender, "change_maid_model");
                    } else {
                        sender.sendSystemMessage((Component)Component.translatable((String)"message.touhou_little_maid.change_model.disabled"));
                    }
                }
            });
        }
    }
}

