/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.config.subconfig.MiscConfig;
import com.github.tartaricacid.touhoulittlemaid.entity.item.EntityPowerPoint;
import com.github.tartaricacid.touhoulittlemaid.entity.passive.EntityMaid;
import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class TileEntityMaidBeacon
extends BlockEntity {
    public static final BlockEntityType<TileEntityMaidBeacon> TYPE = BlockEntityType.Builder.of(TileEntityMaidBeacon::new, (Block[])new Block[]{(Block)InitBlocks.MAID_BEACON.get()}).build(null);
    public static final String POTION_INDEX_TAG = "PotionIndex";
    public static final String STORAGE_POWER_TAG = "StoragePower";
    public static final String OVERFLOW_DELETE_TAG = "OverflowDelete";
    private int potionIndex = -1;
    private float storagePower;
    private boolean overflowDelete = false;

    public TileEntityMaidBeacon(BlockPos blockPos, BlockState blockState) {
        super(TYPE, blockPos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, TileEntityMaidBeacon beacon) {
        if (beacon.level != null && !level.isClientSide && level.getGameTime() % 80L == 0L) {
            if (beacon.potionIndex != -1 && beacon.storagePower >= beacon.getEffectCost()) {
                beacon.storagePower -= beacon.getEffectCost();
                beacon.updateBeaconEffect(level, BeaconEffect.getEffectByIndex(beacon.potionIndex).getEffect());
            }
            beacon.updateAbsorbPower(level);
        }
    }

    private void updateBeaconEffect(Level world, Holder<MobEffect> potion) {
        List list = world.getEntitiesOfClass(EntityMaid.class, new AABB(this.getBlockPos()).inflate(8.0, 8.0, 8.0), LivingEntity::isAlive);
        for (EntityMaid maid : list) {
            maid.addEffect(new MobEffectInstance(potion, 100, 1, true, true));
        }
    }

    private void updateAbsorbPower(Level world) {
        int range = (Integer)MiscConfig.SHRINE_LAMP_MAX_RANGE.get();
        List list = world.getEntitiesOfClass(EntityPowerPoint.class, new AABB(this.getBlockPos()).inflate((double)range, (double)range, (double)range), Entity::isAlive);
        for (EntityPowerPoint powerPoint : list) {
            float addNum = this.getStoragePower() + (float)powerPoint.value / 100.0f;
            if (addNum <= this.getMaxStorage()) {
                this.setStoragePower(addNum);
                powerPoint.spawnExplosionParticle();
                powerPoint.discard();
                continue;
            }
            if (!this.overflowDelete) continue;
            powerPoint.spawnExplosionParticle();
            powerPoint.discard();
        }
    }

    public void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        this.getPersistentData().putInt(POTION_INDEX_TAG, this.potionIndex);
        this.getPersistentData().putFloat(STORAGE_POWER_TAG, this.storagePower);
        this.getPersistentData().putBoolean(OVERFLOW_DELETE_TAG, this.overflowDelete);
        super.saveAdditional(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.potionIndex = this.getPersistentData().getInt(POTION_INDEX_TAG);
        this.storagePower = this.getPersistentData().getFloat(STORAGE_POWER_TAG);
        this.overflowDelete = this.getPersistentData().getBoolean(OVERFLOW_DELETE_TAG);
    }

    public void loadData(CompoundTag data) {
        this.potionIndex = data.getInt(POTION_INDEX_TAG);
        this.storagePower = data.getFloat(STORAGE_POWER_TAG);
        this.overflowDelete = data.getBoolean(OVERFLOW_DELETE_TAG);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public int getPotionIndex() {
        return this.potionIndex;
    }

    public void setPotionIndex(int potionIndex) {
        this.potionIndex = potionIndex;
        this.refresh();
    }

    public float getStoragePower() {
        return this.storagePower;
    }

    public void setStoragePower(float storagePower) {
        this.storagePower = storagePower;
        this.refresh();
    }

    public boolean isOverflowDelete() {
        return this.overflowDelete;
    }

    public void setOverflowDelete(boolean overflowDelete) {
        this.overflowDelete = overflowDelete;
        this.refresh();
    }

    public float getEffectCost() {
        return (float)((Double)MiscConfig.SHRINE_LAMP_EFFECT_COST.get() / 900.0);
    }

    public float getMaxStorage() {
        return ((Double)MiscConfig.SHRINE_LAMP_MAX_STORAGE.get()).floatValue();
    }

    public void refresh() {
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public static enum BeaconEffect {
        SPEED((Holder<MobEffect>)MobEffects.MOVEMENT_SPEED),
        FIRE_RESISTANCE((Holder<MobEffect>)MobEffects.FIRE_RESISTANCE),
        STRENGTH((Holder<MobEffect>)MobEffects.DAMAGE_BOOST),
        RESISTANCE((Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE),
        REGENERATION((Holder<MobEffect>)MobEffects.REGENERATION);

        private final Holder<MobEffect> effect;

        private BeaconEffect(Holder<MobEffect> effect) {
            this.effect = effect;
        }

        public static BeaconEffect getEffectByIndex(int index) {
            return BeaconEffect.values()[Mth.clamp((int)0, (int)index, (int)(BeaconEffect.values().length - 1))];
        }

        public Holder<MobEffect> getEffect() {
            return this.effect;
        }
    }
}

