/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.touhoulittlemaid.tileentity;

import com.github.tartaricacid.touhoulittlemaid.init.InitBlocks;
import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class TileEntityModelSwitcher
extends BlockEntity {
    public static final BlockEntityType<TileEntityModelSwitcher> TYPE = BlockEntityType.Builder.of(TileEntityModelSwitcher::new, (Block[])new Block[]{(Block)InitBlocks.MODEL_SWITCHER.get()}).build(null);
    public static final String INFO_LIST = "info_list";
    public static final String ENTITY_UUID = "entity_uuid";
    public static final String LIST_INDEX = "list_index";
    private List<ModeInfo> infoList = Lists.newArrayList();
    private boolean isPowered;
    private UUID uuid;
    private int index;

    public TileEntityModelSwitcher(BlockPos pWorldPosition, BlockState pBlockState) {
        super(TYPE, pWorldPosition, pBlockState);
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        ListTag listTag = new ListTag();
        for (ModeInfo info : this.infoList) {
            listTag.add((Object)info.serialize());
        }
        this.getPersistentData().put(INFO_LIST, (Tag)listTag);
        if (this.uuid != null) {
            this.getPersistentData().put(ENTITY_UUID, (Tag)NbtUtils.createUUID((UUID)this.uuid));
        }
        this.getPersistentData().putInt(LIST_INDEX, this.index);
        super.saveAdditional(pTag, pRegistries);
    }

    public void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.infoList.clear();
        ListTag listTag = this.getPersistentData().getList(INFO_LIST, 10);
        for (int i = 0; i < listTag.size(); ++i) {
            ModeInfo info = new ModeInfo();
            info.deserialize(listTag.getCompound(i));
            this.infoList.add(info);
        }
        Tag uuidTag = this.getPersistentData().get(ENTITY_UUID);
        if (uuidTag != null) {
            this.uuid = NbtUtils.loadUUID((Tag)uuidTag);
        }
        this.index = this.getPersistentData().getInt(LIST_INDEX);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Nullable
    public UUID getUuid() {
        return this.uuid;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
        this.refresh();
    }

    public boolean isPowered() {
        return this.isPowered;
    }

    public void setPowered(boolean powered) {
        this.isPowered = powered;
    }

    @Nullable
    public ModeInfo getModelInfo() {
        if (0 <= this.index && this.index < this.infoList.size()) {
            return this.infoList.get(this.index);
        }
        return null;
    }

    public List<ModeInfo> getInfoList() {
        return this.infoList;
    }

    public void setInfoList(List<ModeInfo> infoList) {
        this.infoList = infoList;
        this.refresh();
    }

    public void refresh() {
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public static class ModeInfo {
        public static final StreamCodec<ByteBuf, ModeInfo> MODE_INFO_STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, ModeInfo::getModelId, (StreamCodec)ByteBufCodecs.STRING_UTF8, ModeInfo::getText, (StreamCodec)Direction.STREAM_CODEC, ModeInfo::getDirection, ModeInfo::new);
        private ResourceLocation modelId;
        private String text;
        private Direction direction;

        public ModeInfo() {
        }

        public ModeInfo(ResourceLocation modelId, String text, Direction direction) {
            this.modelId = modelId;
            this.text = text;
            this.direction = direction;
        }

        public static ModeInfo fromBuf(FriendlyByteBuf buf) {
            return new ModeInfo(buf.readResourceLocation(), buf.readUtf(), Direction.from2DDataValue((int)buf.readVarInt()));
        }

        public ResourceLocation getModelId() {
            return this.modelId;
        }

        public void setModelId(ResourceLocation modelId) {
            this.modelId = modelId;
        }

        public String getText() {
            return this.text;
        }

        public void setText(String text) {
            this.text = text;
        }

        public Direction getDirection() {
            return this.direction;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public void toBuf(FriendlyByteBuf buf) {
            buf.writeResourceLocation(this.modelId);
            buf.writeUtf(this.text);
            buf.writeVarInt(this.direction.get2DDataValue());
        }

        public CompoundTag serialize() {
            CompoundTag tag = new CompoundTag();
            tag.putString("model_id", this.modelId.toString());
            tag.putString("text", this.text);
            tag.putInt("direction", this.direction.get2DDataValue());
            return tag;
        }

        public void deserialize(CompoundTag nbt) {
            this.modelId = ResourceLocation.parse((String)nbt.getString("model_id"));
            this.text = nbt.getString("text");
            this.direction = Direction.from2DDataValue((int)nbt.getInt("direction"));
        }
    }
}

