/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.api.entity.mobs;

import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.registries.DeferredHolder;

public interface MagicAbyssalSummon
extends IMagicSummon {
    default public void onRemovedHelper(Entity entity, DeferredHolder<MobEffect, SummonTimer> holder) {
        LivingEntity livingEntity;
        Entity.RemovalReason reason = entity.getRemovalReason();
        if (reason != null && (livingEntity = this.getSummoner()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (reason.shouldDestroy()) {
                MobEffectInstance effect = player.getEffect(holder);
                if (effect != null) {
                    MobEffectInstance decrement = new MobEffectInstance(holder, effect.getDuration(), effect.getAmplifier() - 1, false, false, true);
                    if (decrement.getAmplifier() >= 0) {
                        player.getActiveEffectsMap().put(holder, decrement);
                        player.connection.send((Packet)new ClientboundUpdateMobEffectPacket(player.getId(), decrement, false));
                    } else {
                        player.removeEffect(holder);
                    }
                }
                if (reason.equals((Object)Entity.RemovalReason.DISCARDED)) {
                    player.sendSystemMessage((Component)Component.translatable((String)"ui.traveloptics.abyssal_summon_despawn_message", (Object[])new Object[]{((Entity)this).getDisplayName()}));
                }
            }
        }
    }
}

