/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class SwingCounterManager {
    private static final String SWING_COUNTER_TAG = "TOSwingCounter";

    public static int getSwingCount(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            return ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getInt(SWING_COUNTER_TAG);
        }
        return 1;
    }

    public static void setSwingCount(ItemStack stack, int count) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt(SWING_COUNTER_TAG, count));
    }

    public static void incrementSwingCount(ItemStack stack, int maxSwings) {
        int current = SwingCounterManager.getSwingCount(stack);
        SwingCounterManager.setSwingCount(stack, current >= maxSwings ? 1 : current + 1);
    }
}

