/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.data_manager;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public class WeaponFormManager {
    private static final String FORM_NBT_TAG = "WeaponForm";

    public static int getForm(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            return ((CustomData)stack.get(DataComponents.CUSTOM_DATA)).copyTag().getInt(FORM_NBT_TAG);
        }
        return 0;
    }

    public static void setForm(ItemStack stack, int form, int maxForms) {
        int cappedForm = Math.max(0, Math.min(form, maxForms - 1));
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putInt(FORM_NBT_TAG, cappedForm));
    }

    public static void cycleForm(ItemStack stack, int maxForms) {
        int newForm = (WeaponFormManager.getForm(stack) + 1) % maxForms;
        WeaponFormManager.setForm(stack, newForm, maxForms);
    }
}

