/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.effects;

import com.gametechbc.traveloptics.util.TOParticleHelper;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.particle.BlastwaveParticleOptions;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class AstralPathRevealEffect
extends MobEffect {
    public AstralPathRevealEffect() {
        super(MobEffectCategory.NEUTRAL, 11393254);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Mob mob;
        Path path;
        if (!entity.level().isClientSide && entity instanceof Mob && (path = (mob = (Mob)entity).getNavigation().getPath()) != null && !path.isDone()) {
            ServerLevel level = (ServerLevel)entity.level();
            int lastNodeIndex = path.getNodeCount() - 1;
            for (int i = path.getNextNodeIndex(); i < lastNodeIndex; ++i) {
                Node node = path.getNode(i);
                BlockPos pos = new BlockPos(node.x, node.y, node.z);
                Vec3 particlePos = Vec3.atBottomCenterOf((Vec3i)pos).add(0.0, 0.1, 0.0);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)TOParticleHelper.ABYSS_SPIKE_PARTICLE, (double)particlePos.x, (double)(particlePos.y + (double)0.165f), (double)particlePos.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.01, (boolean)true);
            }
            if (lastNodeIndex >= 0) {
                Node lastNode = path.getNode(lastNodeIndex);
                Vec3 endPos = new Vec3((double)lastNode.x + 0.5, (double)((float)lastNode.y + 0.165f), (double)lastNode.z + 0.5);
                MagicManager.spawnParticles((Level)level, (ParticleOptions)new BlastwaveParticleOptions(((SchoolType)SchoolRegistry.ENDER.get()).getTargetingColor(), 1.5f), (double)endPos.x, (double)endPos.y, (double)endPos.z, (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (boolean)true);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }
}

