/*
 * Decompiled with CFR 0.152.
 */
package com.gametechbc.traveloptics.entity.extended;

import com.github.L_Ender.cataclysm.entity.projectile.Wither_Howitzer_Entity;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;

public class ExtendedWitherHowitzerEntity
extends Wither_Howitzer_Entity {
    private float aoeEntityDamage;

    public ExtendedWitherHowitzerEntity(EntityType<? extends Wither_Howitzer_Entity> type, Level world) {
        super(type, world);
        this.aoeEntityDamage = 1.0f;
    }

    public ExtendedWitherHowitzerEntity(EntityType<? extends Wither_Howitzer_Entity> type, Level world, LivingEntity thrower, float entityHitDamage, float aoeEntityDamage) {
        super(type, world, thrower);
        this.aoeEntityDamage = aoeEntityDamage;
    }

    protected void onHit(HitResult hitResult) {
        super.onHit(hitResult);
        if (!this.level().isClientSide) {
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), this.getRadius(), false, Level.ExplosionInteraction.NONE);
            this.applyAoeDamage(this.getX(), this.getY(), this.getZ(), this.getAoeEntityDamage(), this.getRadius());
            this.discard();
        }
    }

    private void applyAoeDamage(double x, double y, double z, float damage, float radius) {
        List nearbyEntities = this.level().getEntitiesOfClass(LivingEntity.class, new AABB(x - (double)radius, y - (double)radius, z - (double)radius, x + (double)radius, y + (double)radius, z + (double)radius));
        for (LivingEntity entity : nearbyEntities) {
            if (!(this.distanceToSqr((Entity)entity) <= (double)(radius * radius))) continue;
            entity.hurt(this.damageSources().magic(), damage);
        }
    }

    public void setAoeEntityDamage(float aoeEntityDamage) {
        this.aoeEntityDamage = aoeEntityDamage;
    }

    public float getAoeEntityDamage() {
        return this.aoeEntityDamage;
    }
}

