/*
 * Decompiled with CFR 0.152.
 */
package com.thedrofdoctoring.vampiricageing.capabilities;

import com.thedrofdoctoring.vampiricageing.AgeingReference;
import com.thedrofdoctoring.vampiricageing.VampiricAgeing;
import com.thedrofdoctoring.vampiricageing.actions.VampiricAgeingActions;
import com.thedrofdoctoring.vampiricageing.capabilities.AgeingManager;
import com.thedrofdoctoring.vampiricageing.capabilities.CapabilityHelper;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.AgeingRegistry;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.IAgeType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.DrinkBloodMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.HuntingMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.methods.TimeMethod;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.HunterAgeingType;
import com.thedrofdoctoring.vampiricageing.capabilities.ageing.types.TypeState;
import com.thedrofdoctoring.vampiricageing.config.CommonConfig;
import com.thedrofdoctoring.vampiricageing.data.AgeingDataComponents;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.player.actions.ILastingAction;
import de.teamlapen.vampirism.api.entity.player.vampire.IDrinkBloodContext;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.event.BloodDrinkEvent;
import de.teamlapen.vampirism.api.event.PlayerFactionEvent;
import de.teamlapen.vampirism.blocks.CoffinBlock;
import de.teamlapen.vampirism.core.ModDamageTypes;
import de.teamlapen.vampirism.core.ModDataComponents;
import de.teamlapen.vampirism.core.ModEffects;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.core.ModTags;
import de.teamlapen.vampirism.effects.SanguinareEffect;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.entity.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.entity.vampire.AdvancedVampireEntity;
import de.teamlapen.vampirism.entity.vampire.DrinkBloodContext;
import de.teamlapen.vampirism.fluids.BloodHelper;
import de.teamlapen.vampirism.items.BloodBottleItem;
import de.teamlapen.vampirism.items.component.BottleBlood;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism.util.VampirismEventFactory;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="vampiricageing")
public class AgeingEventHandler {
    @SubscribeEvent
    public static void onEntityDeath(LivingDeathEvent event) {
        Player player;
        AgeingManager manager;
        IAgeMethod iAgeMethod;
        Entity entity = event.getSource().getEntity();
        if (entity instanceof Player && (iAgeMethod = (manager = AgeingManager.getAge(player = (Player)entity)).getMethod()) instanceof HuntingMethod) {
            HuntingMethod method = (HuntingMethod)iAgeMethod;
            method.onAgedKill(event.getEntity(), player);
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingIncomingDamageEvent event) {
        VampirePlayer vamp;
        Player player;
        LivingEntity target = event.getEntity();
        Entity source = event.getSource().getEntity();
        if (source instanceof Player && Helper.isVampire((Player)(player = (Player)source)) && (vamp = VampirePlayer.get((Player)player)).getActionHandler().isActionActive((ILastingAction)VampiricAgeingActions.DRAIN_BLOOD_ACTION.get())) {
            IVampirePlayer.BITE_TYPE biteType = vamp.determineBiteType(target);
            int blood = 0;
            float saturationMod = 1.0f;
            if (biteType == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_PLAYER) {
                VampirePlayer v = VampirePlayer.get((Player)((Player)target));
                blood = v.onBite((IVampire)vamp);
                saturationMod = v.getBloodSaturation();
            } else if (biteType == IVampirePlayer.BITE_TYPE.HUNTER_CREATURE && target instanceof Player) {
                Player targetPlayer = (Player)target;
                targetPlayer.getFoodData().addExhaustion(1.0f);
                blood = 1;
                saturationMod = 0.1f;
            } else if (biteType == IVampirePlayer.BITE_TYPE.SUCK_BLOOD_CREATURE) {
                Optional opt = ExtendedCreature.getSafe((Entity)target);
                blood = opt.map(creature -> creature.onBite((IVampire)vamp)).orElse(0);
                saturationMod = opt.map(IBiteableEntity::getBloodSaturation).orElse(Float.valueOf(0.0f)).floatValue();
            }
            DrinkBloodContext context = new DrinkBloodContext(target);
            vamp.drinkBlood(blood, saturationMod, (IDrinkBloodContext)context);
            VampirismEventFactory.fireVampirePlayerDrinkBloodEvent((IVampirePlayer)vamp, (int)blood, (float)saturationMod, (boolean)true, (IDrinkBloodContext)context);
        }
    }

    @SubscribeEvent
    public static void onCoffinInteract(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (Helper.isVampire((Player)player) && !player.getCommandSenderWorld().isClientSide && player.getCommandSenderWorld().getBlockState(event.getPos()).getBlock() instanceof CoffinBlock && AgeingManager.getAge(player).canAge()) {
            AgeingManager age = AgeingManager.getAge(player);
            int points = age.getRankProgress();
            points = age.getMethod().getRankProgressions()[age.getAge()] - points;
            player.displayClientMessage((Component)Component.translatable((String)age.getMethod().getRemainingLang(), (Object[])new Object[]{points}).withStyle(ChatFormatting.DARK_RED), true);
        }
    }

    @SubscribeEvent
    public static void vampireDrinkBlood(BloodDrinkEvent.PlayerDrinkBloodEvent event) {
        Player player;
        AgeingManager age;
        if (event.getBloodSource().getEntity().isPresent() && (age = AgeingManager.getAge(player = (Player)event.getVampire().getRepresentingEntity())).getMethod() instanceof DrinkBloodMethod && !player.getCommandSenderWorld().isClientSide && age.canAge()) {
            age.increaseRankPoints(event.getAmount());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AdvancedVampireEntity) {
            AdvancedVampireEntity vamp = (AdvancedVampireEntity)entity;
            if (((Boolean)CommonConfig.advancedVampireAge.get()).booleanValue() && !event.getEntity().getCommandSenderWorld().isClientSide) {
                AgeingManager manager = AgeingManager.getAge((PathfinderMob)vamp);
                if (manager.getAge() != 0) {
                    return;
                }
                List percentages = (List)CommonConfig.percentageAdvancedVampireAges.get();
                double random = vamp.getRandom().nextDouble();
                double cumulative = 0.0;
                manager.setType(AgeingReference.VAMP);
                for (int i = 0; i < percentages.size(); ++i) {
                    if (!(random <= (cumulative += ((Double)percentages.get(i)).doubleValue()))) continue;
                    manager.setAge(i);
                    break;
                }
                float ageMultiplier = Math.min(1.0f, (float)manager.getAge() / 2.0f);
                ResourceLocation MAX_HEALTH = VampiricAgeing.rl("adv_vamp_age_health");
                ResourceLocation ATTACK_DAMAGE = VampiricAgeing.rl("adv_vamp_age_damage");
                ResourceLocation KNOCKBACK_RESISTANCE = VampiricAgeing.rl("adv_vamp_age_resistance");
                ResourceLocation SPEED = VampiricAgeing.rl("adv_vamp_age_speed");
                AgeingManager.removeModifier(vamp.getAttribute(Attributes.MAX_HEALTH), MAX_HEALTH);
                AgeingManager.removeModifier(vamp.getAttribute(Attributes.ATTACK_DAMAGE), ATTACK_DAMAGE);
                AgeingManager.removeModifier(vamp.getAttribute(Attributes.KNOCKBACK_RESISTANCE), KNOCKBACK_RESISTANCE);
                AgeingManager.removeModifier(vamp.getAttribute(Attributes.MOVEMENT_SPEED), SPEED);
                vamp.getAttribute(Attributes.MAX_HEALTH).addPermanentModifier(new AttributeModifier(MAX_HEALTH, (double)ageMultiplier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                vamp.getAttribute(Attributes.ATTACK_DAMAGE).addPermanentModifier(new AttributeModifier(ATTACK_DAMAGE, (double)ageMultiplier, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                vamp.getAttribute(Attributes.KNOCKBACK_RESISTANCE).addPermanentModifier(new AttributeModifier(KNOCKBACK_RESISTANCE, 0.25 * (double)ageMultiplier, AttributeModifier.Operation.ADD_VALUE));
                vamp.setHealth(vamp.getMaxHealth());
                if (manager.getAge() > 2) {
                    vamp.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(SPEED, 0.2 * (double)ageMultiplier, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleAgeMethod(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CapabilityHelper.setDefaultAgeTypeAndMethod(player);
        }
    }

    @SubscribeEvent
    public static void onPotionEffectRemove(MobEffectEvent.Remove event) {
        LivingEntity livingEntity;
        if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && event.getEffect() == ModEffects.SANGUINARE.get() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (!event.getEntity().getCommandSenderWorld().isClientSide) {
                player.getPersistentData().remove("AGE");
            }
        }
    }

    @SubscribeEvent
    public static void onDamage(LivingIncomingDamageEvent event) {
        Entity vp;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (Helper.isVampire((Entity)event.getEntity())) {
                int age = AgeingManager.getAge(player).getAge();
                if (!Helper.canKillVampires((DamageSource)event.getSource()) && event.getAmount() >= event.getEntity().getHealth() && ((Boolean)CommonConfig.shouldOnlyDieFromKillingSources.get()).booleanValue() && age >= (Integer)CommonConfig.shouldOnlyDieFromKillingSourcesAgeRank.get()) {
                    vp = VampirePlayer.get((Player)player);
                    if (event.getAmount() >= (float)((Integer)CommonConfig.bloodlossDamageThreshold.get()).intValue()) {
                        int bloodLoss = Math.round(((Double)CommonConfig.bloodlossScaleFactor.get()).floatValue() * Math.min(event.getAmount(), ((Integer)CommonConfig.bloodlossDamageCap.get()).floatValue()));
                        vp.useBlood(bloodLoss, false);
                    }
                    if (!((float)vp.getBloodLevel() <= 0.5f)) {
                        player.setHealth(1.0f);
                        event.setCanceled(true);
                    }
                }
                if (event.getSource().is(ModDamageTypes.SUN_DAMAGE)) {
                    event.setAmount(event.getAmount() / ((Double)((List)CommonConfig.sunDamageReduction.get()).get(age)).floatValue());
                } else if (event.getSource().is(ModDamageTypes.VAMPIRE_IN_FIRE) || event.getSource().is(ModDamageTypes.VAMPIRE_ON_FIRE) || event.getSource().is(ModDamageTypes.HOLY_WATER)) {
                    if (((Boolean)CommonConfig.rageModeWeaknessToggle.get()).booleanValue() && VampirePlayer.getOpt((Player)player).map(vamp -> vamp.getActionHandler().isActionActive((ILastingAction)VampireActions.VAMPIRE_RAGE.get())).orElse(false).booleanValue() && ((Double)((List)CommonConfig.genericVampireWeaknessReduction.get()).get(age)).floatValue() < 1.0f) {
                        return;
                    }
                    if (!event.getSource().is(ModDamageTypes.HOLY_WATER) && ((Boolean)CommonConfig.deadlySourcesFastDrainExhaustion.get()).booleanValue() && event.getEntity() instanceof Player) {
                        VampirePlayer.getOpt((Player)player).ifPresent(vamp -> vamp.addExhaustion(((Double)((List)CommonConfig.amountExhaustionDrainFromSources.get()).get(age)).floatValue()));
                    }
                    event.setAmount(event.getAmount() / ((Double)((List)CommonConfig.genericVampireWeaknessReduction.get()).get(age)).floatValue());
                } else if (event.getSource().is(DamageTypes.STARVE) && ((Boolean)CommonConfig.harsherOutOfBlood.get()).booleanValue() && age > 0) {
                    event.setAmount(event.getAmount() * (float)age);
                } else if (event.getSource().getEntity() != null && event.getSource().getEntity().getType().is(ModTags.Entities.HUNTER) && ((Boolean)CommonConfig.shouldAgeIncreaseHunterMobDamage.get()).booleanValue()) {
                    event.setAmount(event.getAmount() * ((Double)((List)CommonConfig.damageMultiplierFromHunters.get()).get(age)).floatValue());
                }
            }
        }
        if ((vp = event.getSource().getEntity()) instanceof AdvancedVampireEntity) {
            AgeingManager age;
            ServerPlayer player;
            AdvancedVampireEntity vamp2 = (AdvancedVampireEntity)vp;
            if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && (vp = event.getEntity()) instanceof ServerPlayer && Helper.canBecomeVampire((Player)(player = (ServerPlayer)vp)) && (age = AgeingManager.getAge((PathfinderMob)vamp2)).getAge() > 1 && (double)vamp2.getRandom().nextFloat() > 0.85) {
                SanguinareEffect.addRandom((LivingEntity)player, (boolean)true);
                player.getPersistentData().remove("AGE");
                player.getPersistentData().putInt("AGE", age.getAge() - 1);
            }
        }
    }

    @SubscribeEvent
    public static void onChangeFaction(PlayerFactionEvent.FactionLevelChanged event) {
        if (event.getNewLevel() == 0 || event.getCurrentFaction() != event.getOldFaction() && event.getOldFaction() != null) {
            Player player = event.getPlayer().asEntity();
            age = AgeingManager.getAge(player);
            IAgeType type = age.getAgeType();
            age.setAge(0);
            CapabilityHelper.setDefaultAgeTypeAndMethod(player);
            if (!player.getCommandSenderWorld().isClientSide) {
                age.onAgeChange((ServerPlayer)player, type);
            }
            if (event.getOldFaction() == VReference.HUNTER_FACTION && event.getCurrentFaction() != event.getOldFaction()) {
                TypeState typeState;
                if (player.hasEffect(com.thedrofdoctoring.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT)) {
                    player.removeEffect(com.thedrofdoctoring.vampiricageing.init.ModEffects.TAINTED_BLOOD_EFFECT);
                }
                if ((typeState = age.getTypeState()) instanceof HunterAgeingType.HunterState) {
                    HunterAgeingType.HunterState state = (HunterAgeingType.HunterState)typeState;
                    state.setTransformed(false);
                }
            }
        } else if (event.getNewLevel() > 0 && event.getCurrentFaction() == VReference.VAMPIRE_FACTION && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && event.getPlayer().getPlayer().getPersistentData().contains("AGE")) {
            int sireAge = event.getPlayer().asEntity().getPersistentData().getInt("AGE");
            age = AgeingManager.getAge(event.getPlayer().asEntity());
            age.setAge(sireAge);
            age.sync(true);
            event.getPlayer().asEntity().getPersistentData().remove("AGE");
        }
        if (event.getNewLevel() > 0 && event.getCurrentFaction() != null) {
            AgeingManager man = AgeingManager.getAge(event.getPlayer().asEntity());
            for (IAgeType type : AgeingRegistry.getAgeingTypes()) {
                if (event.getNewLevel() < type.minFactionRank() || type.faction() != event.getCurrentFaction()) continue;
                man.setType(type);
                man.setAge(0);
                CapabilityHelper.setDefaultAgeTypeAndMethod(event.getPlayer().asEntity());
            }
        }
    }

    @SubscribeEvent
    public static void onTick(PlayerTickEvent.Post event) {
        ServerPlayer sPlayer;
        AgeingManager age;
        Player player;
        Player player2 = event.getEntity();
        if (player2.tickCount % 100 == 0 && (player = event.getEntity()) instanceof ServerPlayer && (age = AgeingManager.getAge((Player)(sPlayer = (ServerPlayer)player))).getMethod() instanceof TimeMethod && age.canAge()) {
            age.setRankProgress(age.getRankProgress() + 100);
            age.sync(false);
        }
        if (player2.tickCount % 20 == 0 && ((Boolean)CommonConfig.deadlySourcesFastDrainExhaustion.get()).booleanValue()) {
            if (!event.getEntity().hasEffect((Holder)ModEffects.GARLIC)) {
                return;
            }
            if (!Helper.isVampire((Player)player2)) {
                return;
            }
            int age2 = AgeingManager.getAge(player2).getAge();
            VampirePlayer vamp = VampirePlayer.get((Player)player2);
            vamp.addExhaustion(((Double)((List)CommonConfig.amountExhaustionDrainFromSources.get()).get(age2)).floatValue());
        }
    }

    @SubscribeEvent
    public static void sireBloodInteract(PlayerInteractEvent.RightClickBlock event) {
        int age;
        Player player = event.getEntity();
        if (player.isShiftKeyDown() && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && Helper.isVampire((Player)player) && event.getHand() == InteractionHand.MAIN_HAND && event.getItemStack().is(Items.GLASS_BOTTLE) && (age = AgeingManager.getAge(player).getAge()) > 1 && VampirePlayer.get((Player)player).getBloodLevel() > 8) {
            ItemStack mainHandStack = player.getMainHandItem();
            mainHandStack.shrink(1);
            ItemStack stack = ((BloodBottleItem)ModItems.BLOOD_BOTTLE.get()).getDefaultInstance();
            stack.set(AgeingDataComponents.AGE_RANK, (Object)(--age));
            stack.setDamageValue(4);
            player.addItem(stack);
            VampirePlayer.getOpt((Player)player).ifPresent(vamp -> vamp.removeBlood(0.5f));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeath(LivingDeathEvent event) {
        Entity entity;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (((Boolean)CommonConfig.deathReset.get()).booleanValue()) {
                AgeingManager age = AgeingManager.getAge((Player)player);
                age.setAge(0);
                age.sync(true);
            }
        }
        LivingEntity dead = event.getEntity();
        if (!dead.getCommandSenderWorld().isClientSide && (entity = event.getSource().getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && player.getOffhandItem().is(Items.GLASS_BOTTLE) && Helper.isVampire((Entity)dead) && (dead instanceof AdvancedVampireEntity || dead instanceof Player)) {
                int age = AgeingManager.getAge(dead).get().getAge();
                ItemStack offHandStack = player.getOffhandItem();
                offHandStack.shrink(1);
                ItemStack stack = ((BloodBottleItem)ModItems.BLOOD_BOTTLE.get()).getDefaultInstance();
                stack.set((Supplier)ModDataComponents.BOTTLE_BLOOD, (Object)new BottleBlood(1));
                stack.set(AgeingDataComponents.AGE_RANK, (Object)age);
                player.addItem(stack);
            }
        }
        if (dead.getPersistentData().contains("AGE")) {
            dead.getPersistentData().remove("AGE");
        }
    }

    @SubscribeEvent
    public static void tooltipEvent(ItemTooltipEvent event) {
        int age;
        ItemStack stack = event.getItemStack();
        if (stack.is((Item)ModItems.BLOOD_BOTTLE.get()) && ((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && (age = ((Integer)stack.getOrDefault(AgeingDataComponents.AGE_RANK, (Object)0)).intValue()) > 0) {
            event.getToolTip().add(Component.translatable((String)"text.vampiricageing.blood_rank").append(String.valueOf(age)));
        }
    }

    @SubscribeEvent
    public static void useItem(LivingEntityUseItemEvent.Stop event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = event.getItem();
        if (BloodHelper.getBlood((ItemStack)stack) != 0) {
            return;
        }
        if (((Boolean)CommonConfig.sireingMechanic.get()).booleanValue() && entity instanceof Player) {
            Player player = (Player)entity;
            if (Helper.isVampire((Entity)entity) && event.getItem().is((Item)ModItems.BLOOD_BOTTLE.get())) {
                int age = (Integer)stack.getOrDefault(AgeingDataComponents.AGE_RANK, (Object)0);
                AgeingManager manager = AgeingManager.getAge(player);
                if (manager.getAge() < age) {
                    manager.setAge(age);
                    manager.sync(false);
                }
            }
        }
    }
}

